/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.items;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.renderers.OceanShieldRenderer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShieldItem;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class OceanShieldItem
extends ShieldItem {
    public OceanShieldItem() {
        super(new Item.Properties().m_41503_(555).m_41497_(Rarity.UNCOMMON).m_41491_(Instances.ITEM_GROUP));
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return Items.f_42695_.equals(repair.m_41720_()) || Items.f_42696_.equals(repair.m_41720_());
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SHIELD_BLOCK);
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        LivingEntity target = event.getEntityLiving();
        OceanShieldItem oceanShieldItem = Instances.OCEAN_SHIELD_ITEM;
        ItemStack mainHandItemStack = target.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHandItemStack = target.m_21120_(InteractionHand.OFF_HAND);
        boolean isBlockingWithShield = target.m_21254_();
        if (((Object)((Object)oceanShieldItem)).equals(mainHandItemStack.m_41720_())) {
            if (isBlockingWithShield) {
                OceanShieldItem.reflectDamage(event.getSource(), target, mainHandItemStack, InteractionHand.MAIN_HAND);
            }
        } else if (((Object)((Object)oceanShieldItem)).equals(offHandItemStack.m_41720_()) && isBlockingWithShield) {
            OceanShieldItem.reflectDamage(event.getSource(), target, offHandItemStack, InteractionHand.OFF_HAND);
        }
    }

    private static void reflectDamage(DamageSource damageSource, LivingEntity target, ItemStack shieldItem, InteractionHand hand) {
        if (!(damageSource.m_7640_() instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)damageSource.m_7640_();
        attacker.m_6469_(DamageSource.m_19335_((Entity)target), 3.0f);
        shieldItem.m_41622_(1, target, livingEntity -> livingEntity.m_21190_(hand));
    }

    public int m_6473_() {
        return 1;
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        final Minecraft minecraft = Minecraft.m_91087_();
        consumer.accept(new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return new OceanShieldRenderer(minecraft.m_167982_(), minecraft.m_167973_());
            }
        });
    }
}

