/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.loot_modifiers;

import com.google.gson.JsonObject;
import com.majruszs_difficulty.features.treasure_bag.TreasureBagManager;
import com.majruszs_difficulty.items.TreasureBagItem;
import com.mlib.loot_modifiers.LootHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class AddTreasureBagsToLoot
extends LootModifier {
    public AddTreasureBagsToLoot(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81455_);
        DamageSource damageSource = (DamageSource)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81457_);
        if (entity == null || damageSource == null) {
            return generatedLoot;
        }
        TreasureBagItem treasureBag = TreasureBagManager.getTreasureBag(entity.m_6095_());
        if (treasureBag == null || !(entity instanceof LivingEntity) || !treasureBag.isAvailable()) {
            return generatedLoot;
        }
        if (TreasureBagManager.rewardAllPlayers((LivingEntity)entity) && TreasureBagManager.shouldReplaceLoot(entity.m_6095_())) {
            generatedLoot.clear();
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddTreasureBagsToLoot> {
        public AddTreasureBagsToLoot read(ResourceLocation name, JsonObject object, LootItemCondition[] conditions) {
            return new AddTreasureBagsToLoot(conditions);
        }

        public JsonObject write(AddTreasureBagsToLoot instance) {
            return null;
        }
    }
}

