/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.triggers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.majruszs_difficulty.GameState;
import com.majruszs_difficulty.MajruszsDifficulty;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class GameStateTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = MajruszsDifficulty.getLocation("game_state");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject jsonObject, EntityPredicate.Composite predicate, DeserializationContext conditions) {
        JsonElement stateElement = jsonObject.get("state_id");
        return new Instance(predicate, GameState.convertIntegerToState(stateElement.getAsInt()));
    }

    @SubscribeEvent
    public static void onStart(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            GameState.triggerAdvancement((ServerPlayer)event.getPlayer());
        }
    }

    public void trigger(ServerPlayer player, GameState.State state) {
        this.m_66234_(player, instance -> instance.test(state));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final GameState.State state;

        public Instance(EntityPredicate.Composite player, GameState.State state) {
            super(ID, player);
            this.state = state;
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject jsonObject = super.m_7683_(conditions);
            jsonObject.addProperty("state_id", (Number)GameState.convertStateToInteger(this.state));
            return jsonObject;
        }

        public boolean test(GameState.State state) {
            return GameState.convertStateToInteger(state) >= GameState.convertStateToInteger(this.state);
        }
    }
}

