/*
 * Decompiled with CFR 0.152.
 */
package com.mlib;

import com.mlib.MajruszLibrary;
import com.mlib.config.DoubleConfig;
import com.mlib.math.VectorHelper;
import com.mojang.math.Vector3f;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class Random {
    public static float nextFloat() {
        return MajruszLibrary.RANDOM.nextFloat();
    }

    public static float nextFloat(float min, float max) {
        return (max - min) * MajruszLibrary.RANDOM.nextFloat() + min;
    }

    public static double nextDouble() {
        return MajruszLibrary.RANDOM.nextDouble();
    }

    public static double nextDouble(double min, double max) {
        return (max - min) * MajruszLibrary.RANDOM.nextDouble() + min;
    }

    public static int nextInt() {
        return MajruszLibrary.RANDOM.nextInt();
    }

    public static int nextInt(int max) {
        return MajruszLibrary.RANDOM.nextInt(max);
    }

    public static int nextInt(int min, int max) {
        return min + Random.nextInt(max - min);
    }

    public static boolean nextBoolean() {
        return MajruszLibrary.RANDOM.nextBoolean();
    }

    public static <Type> Type nextRandom(Type[] elements) {
        return elements[Random.nextInt(elements.length)];
    }

    public static boolean tryChance(double chance) {
        return Random.nextDouble() <= chance;
    }

    public static boolean tryChance(DoubleConfig config) {
        return Random.tryChance((Double)config.get());
    }

    public static int roundRandomly(double experience) {
        int outputExperience;
        return outputExperience + (Random.tryChance(experience - (double)(outputExperience = (int)experience)) ? 1 : 0);
    }

    public static Vector3f getRandomVector3f(float minX, float maxX, float minY, float maxY, float minZ, float maxZ) {
        return new Vector3f(Random.nextFloat(minX, maxX), Random.nextFloat(minY, maxY), Random.nextFloat(minZ, maxZ));
    }

    public static Vec3 getRandomVector3d(double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        return new Vec3(Random.nextDouble(minX, maxX), Random.nextDouble(minY, maxY), Random.nextDouble(minZ, maxZ));
    }

    public static Vec3i getRandomVector3i(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        return new Vec3i(Random.nextInt(minX, maxX + 1), Random.nextInt(minY, maxY + 1), Random.nextInt(minZ, maxZ + 1));
    }

    public static Vec3 getRandomNormalizedVector() {
        Vec3 vector = Random.getRandomVector3d(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
        if (VectorHelper.length(vector) < 1.0E-5) {
            return Random.getRandomNormalizedVector();
        }
        return VectorHelper.normalize(vector);
    }
}

