/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.server.command.EnumArgument;

public class BaseCommand {
    private static final String DEFAULT_POSITION_ARGUMENT = "position";
    private static final String DEFAULT_ENTITY_ARGUMENT = "entity";
    private static final String DEFAULT_ENTITIES_ARGUMENT = "entities";

    public static Predicate<CommandSourceStack> hasPermission(int requiredLevel) {
        return commandSourceStack -> commandSourceStack.m_6761_(requiredLevel);
    }

    public static RequiredArgumentBuilder<CommandSourceStack, Integer> integer(String name) {
        return Commands.m_82129_((String)name, (ArgumentType)IntegerArgumentType.integer());
    }

    public static RequiredArgumentBuilder<CommandSourceStack, Integer> integer(String name, int min) {
        return Commands.m_82129_((String)name, (ArgumentType)IntegerArgumentType.integer((int)min));
    }

    public static RequiredArgumentBuilder<CommandSourceStack, Integer> integer(String name, int min, int max) {
        return Commands.m_82129_((String)name, (ArgumentType)IntegerArgumentType.integer((int)min, (int)max));
    }

    public static int getInteger(CommandContext<CommandSourceStack> context, String name) {
        return IntegerArgumentType.getInteger(context, (String)name);
    }

    public static <EnumType extends Enum<EnumType>> RequiredArgumentBuilder<CommandSourceStack, EnumType> enumArgument(String name, Class<EnumType> enumClass) {
        return Commands.m_82129_((String)name, (ArgumentType)EnumArgument.enumArgument(enumClass));
    }

    public static <EnumType extends Enum<EnumType>> EnumType getEnum(CommandContext<CommandSourceStack> context, String name, Class<EnumType> enumClass) {
        return (EnumType)((Enum)context.getArgument(name, enumClass));
    }

    public static <EnumType extends Enum<EnumType>> Optional<EnumType> getOptionalEnum(CommandContext<CommandSourceStack> context, String name, Class<EnumType> enumClass) {
        try {
            return Optional.of((Enum)context.getArgument(name, enumClass));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    public static LiteralArgumentBuilder<CommandSourceStack> literal(String name) {
        return Commands.m_82127_((String)name);
    }

    public static RequiredArgumentBuilder<CommandSourceStack, Coordinates> position(String name) {
        return Commands.m_82129_((String)name, (ArgumentType)Vec3Argument.m_120841_());
    }

    public static Vec3 getPosition(CommandContext<CommandSourceStack> context, String name) {
        return Vec3Argument.m_120844_(context, (String)name);
    }

    public static Optional<Vec3> getOptionalPosition(CommandContext<CommandSourceStack> context, String name) {
        try {
            return Optional.of(BaseCommand.getPosition(context, name));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    public static RequiredArgumentBuilder<CommandSourceStack, Coordinates> position() {
        return BaseCommand.position(DEFAULT_POSITION_ARGUMENT);
    }

    public static Vec3 getPosition(CommandContext<CommandSourceStack> context) {
        return BaseCommand.getPosition(context, DEFAULT_POSITION_ARGUMENT);
    }

    public static Optional<Vec3> getOptionalPosition(CommandContext<CommandSourceStack> context) {
        try {
            return Optional.of(BaseCommand.getPosition(context));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    public static RequiredArgumentBuilder<CommandSourceStack, EntitySelector> entity(String name) {
        return Commands.m_82129_((String)name, (ArgumentType)EntityArgument.m_91449_());
    }

    @Nullable
    public static Entity getEntity(CommandContext<CommandSourceStack> context, String name) {
        try {
            return EntityArgument.m_91452_(context, (String)name);
        }
        catch (CommandSyntaxException exception) {
            return null;
        }
    }

    public static RequiredArgumentBuilder<CommandSourceStack, EntitySelector> entity() {
        return BaseCommand.entity(DEFAULT_ENTITY_ARGUMENT);
    }

    public static Entity getEntity(CommandContext<CommandSourceStack> context) {
        return BaseCommand.getEntity(context, DEFAULT_ENTITY_ARGUMENT);
    }

    public static RequiredArgumentBuilder<CommandSourceStack, EntitySelector> entities(String name) {
        return Commands.m_82129_((String)name, (ArgumentType)EntityArgument.m_91460_());
    }

    @Nullable
    public static Collection<? extends Entity> getEntities(CommandContext<CommandSourceStack> context, String name) {
        try {
            return EntityArgument.m_91461_(context, (String)name);
        }
        catch (CommandSyntaxException exception) {
            return null;
        }
    }

    public static RequiredArgumentBuilder<CommandSourceStack, EntitySelector> entities() {
        return BaseCommand.entities(DEFAULT_ENTITIES_ARGUMENT);
    }

    public static Collection<? extends Entity> getEntities(CommandContext<CommandSourceStack> context) {
        return BaseCommand.getEntities(context, DEFAULT_ENTITIES_ARGUMENT);
    }

    public static class Data {
        public final List<ArgumentBuilder<CommandSourceStack, ?>> arguments = new ArrayList();
        public final List<Predicate<CommandSourceStack>> requirements = new ArrayList<Predicate<CommandSourceStack>>();
        public final LiteralArgumentBuilder<CommandSourceStack> command;

        @SafeVarargs
        public Data(LiteralArgumentBuilder<CommandSourceStack> command, ArgumentBuilder<CommandSourceStack, ?> ... arguments) {
            this.command = command;
            this.addArguments(arguments);
        }

        @SafeVarargs
        public Data(Predicate<CommandSourceStack> requirement, LiteralArgumentBuilder<CommandSourceStack> command, ArgumentBuilder<CommandSourceStack, ?> ... arguments) {
            this(command, arguments);
            this.addRequirements(requirement);
        }

        @SafeVarargs
        public final void addArguments(ArgumentBuilder<CommandSourceStack, ?> ... arguments) {
            Collections.addAll(this.arguments, arguments);
        }

        @SafeVarargs
        public final void addRequirements(Predicate<CommandSourceStack> ... requirements) {
            Collections.addAll(this.requirements, requirements);
        }

        public Data copy() {
            Data dataCopy = new Data(this.command, new ArgumentBuilder[0]);
            dataCopy.arguments.addAll(this.arguments);
            dataCopy.requirements.addAll(this.requirements);
            return dataCopy;
        }

        @SafeVarargs
        public final Data extendCopy(ArgumentBuilder<CommandSourceStack, ?> ... arguments) {
            Data dataCopy = this.copy();
            dataCopy.addArguments(arguments);
            return dataCopy;
        }
    }
}

