/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.enchantments;

import com.mlib.items.ItemHelper;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public abstract class CustomEnchantment
extends Enchantment {
    protected Supplier<Boolean> availability = () -> true;
    protected final Parameters params;

    protected CustomEnchantment(Parameters params) {
        super(params.rarity, params.category, params.slots);
        this.params = params;
    }

    public int m_6586_() {
        return this.params.maxLevel;
    }

    public int m_6183_(int enchantmentLevel) {
        return this.params.minLevelFormula.getPlayerLevel(enchantmentLevel);
    }

    public int m_6175_(int enchantmentLevel) {
        return this.params.maxLevelFormula.getPlayerLevel(enchantmentLevel);
    }

    public boolean m_6081_(ItemStack itemStack) {
        return this.isEnabled() && super.m_6081_(itemStack);
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean canApplyAtEnchantingTable(ItemStack itemStack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(itemStack);
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean m_6591_() {
        return this.params.isCurse;
    }

    public boolean m_6589_() {
        return this.params.isCurse;
    }

    public int getEnchantmentLevel(ItemStack itemStack) {
        return EnchantmentHelper.m_44843_((Enchantment)this, (ItemStack)itemStack);
    }

    public int getEnchantmentLevel(LivingEntity entity) {
        return EnchantmentHelper.m_44836_((Enchantment)this, (LivingEntity)entity);
    }

    public boolean hasEnchantment(ItemStack itemStack) {
        return this.getEnchantmentLevel(itemStack) > 0;
    }

    public boolean hasEnchantment(LivingEntity entity) {
        return this.getEnchantmentLevel(entity) > 0;
    }

    public boolean increaseEnchantmentLevel(ItemStack itemStack) {
        int enchantmentLevel = this.getEnchantmentLevel(itemStack);
        if (enchantmentLevel >= this.m_6586_()) {
            return false;
        }
        if (enchantmentLevel == 0) {
            this.enchantItem(itemStack, 1);
            return true;
        }
        this.setEnchantmentTag(itemStack, enchantmentLevel + 1);
        return true;
    }

    public int getEnchantmentSum(Iterable<ItemStack> itemStacks) {
        int sum = 0;
        for (ItemStack itemStack : itemStacks) {
            sum += this.getEnchantmentLevel(itemStack);
        }
        return sum;
    }

    public int getEnchantmentSum(LivingEntity livingEntity, EquipmentSlot[] slots) {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        for (EquipmentSlot slotType : slots) {
            itemStackList.add(livingEntity.m_6844_(slotType));
        }
        return this.getEnchantmentSum(itemStackList);
    }

    public int getMatchingHandItemEnchantmentLevel(LivingEntity entity, Predicate<ItemStack> predicate) {
        return this.getEnchantmentLevel(ItemHelper.getMatchingHandItem(entity, predicate));
    }

    public ItemStack deduceUsedHandItem(LivingEntity entity) {
        return ItemHelper.getMatchingHandItem(entity, itemStack -> this.params.category.m_7454_(itemStack.m_41720_()));
    }

    public int getDeducedHandEnchantmentLevel(LivingEntity entity) {
        return this.getEnchantmentLevel(this.deduceUsedHandItem(entity));
    }

    public void setEnabledSupplier(Supplier<Boolean> availability) {
        this.availability = availability;
    }

    public Parameters getParams() {
        return this.params;
    }

    protected boolean isEnabled() {
        return this.availability.get();
    }

    protected boolean isDisabled() {
        return !this.isEnabled();
    }

    private void enchantItem(ItemStack itemStack, int level) {
        itemStack.m_41663_((Enchantment)this, level);
    }

    private void setEnchantmentTag(ItemStack itemStack, int level) {
        ListTag nbt = itemStack.m_41785_();
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag enchantmentData = nbt.m_128728_(i);
            String enchantmentID = enchantmentData.m_128461_("id");
            if (!enchantmentID.contains(Registry.f_122825_.m_7981_((Object)this).toString())) continue;
            enchantmentData.m_128405_("lvl", level);
            break;
        }
        itemStack.m_41700_("Enchantments", (Tag)nbt);
    }

    public record Parameters(Enchantment.Rarity rarity, EnchantmentCategory category, EquipmentSlot[] slots, boolean isCurse, int maxLevel, LevelFormula minLevelFormula, LevelFormula maxLevelFormula) {
    }

    @FunctionalInterface
    protected static interface LevelFormula {
        public int getPlayerLevel(int var1);
    }
}

