/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.levels;

import com.mlib.Random;
import com.mlib.math.VectorHelper;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class LevelHelper {
    public static boolean isEntityIn(Entity entity, ResourceKey<Level> worldRegistryKey) {
        return entity.f_19853_.m_46472_() == worldRegistryKey;
    }

    public static DifficultyInstance getDifficultyInstance(Entity entity) {
        return LevelHelper.getDifficultyInstance(entity.f_19853_, entity.m_20182_());
    }

    public static DifficultyInstance getDifficultyInstance(Level level, Vec3 position) {
        return level.m_6436_(new BlockPos(position));
    }

    public static double getRegionalDifficulty(Entity entity) {
        return LevelHelper.getRegionalDifficulty(entity.f_19853_, entity.m_20182_());
    }

    public static double getRegionalDifficulty(Level level, Vec3 position) {
        return LevelHelper.getDifficultyInstance(level, position).m_19056_();
    }

    public static double getClampedRegionalDifficulty(Entity entity) {
        return LevelHelper.getClampedRegionalDifficulty(entity.f_19853_, entity.m_20182_());
    }

    public static double getClampedRegionalDifficulty(Level level, Vec3 position) {
        return LevelHelper.getDifficultyInstance(level, position).m_19057_();
    }

    public static boolean isEntityOutside(Entity entity) {
        return entity.f_19853_.m_45527_(new BlockPos(entity.m_20182_()));
    }

    public static boolean isRainingAtEntityBiome(Entity entity) {
        Level level = entity.f_19853_;
        Biome biome = (Biome)level.m_204166_(new BlockPos(entity.m_20182_())).m_203334_();
        return level.m_46471_() && biome.m_47530_() == Biome.Precipitation.RAIN;
    }

    public static boolean isEntityOutsideWhenItIsRaining(Entity entity) {
        return LevelHelper.isEntityOutside(entity) && LevelHelper.isRainingAtEntityBiome(entity);
    }

    public static boolean isEntityOutsideDuringTheDay(Entity entity) {
        return LevelHelper.isEntityOutside(entity) && entity.f_19853_.m_46461_();
    }

    public static boolean isEntityOutsideDuringTheNight(Entity entity) {
        return LevelHelper.isEntityOutside(entity) && entity.f_19853_.m_46462_();
    }

    @Nullable
    public static ServerLevel getServerLevelFromEntity(@Nullable Entity entity) {
        return entity != null && entity.f_19853_ instanceof ServerLevel ? (ServerLevel)entity.f_19853_ : null;
    }

    public static Pair<Vec3, ServerLevel> getSpawnData(ServerPlayer player) {
        float angle;
        Optional spawnPosition;
        BlockPos respawnPosition = player.m_8961_();
        ServerLevel serverLevel = player.f_8924_.m_129880_(player.m_8963_());
        Vec3 exactSpawnPosition = null;
        if (serverLevel == null) {
            return new Pair((Object)Vec3.f_82478_, null);
        }
        if (respawnPosition != null && (spawnPosition = Player.m_36130_((ServerLevel)serverLevel, (BlockPos)respawnPosition, (float)(angle = player.m_8962_()), (boolean)true, (boolean)true)).isPresent()) {
            exactSpawnPosition = (Vec3)spawnPosition.get();
        }
        if (exactSpawnPosition == null) {
            serverLevel = player.f_8924_.m_129880_(Level.f_46428_);
            assert (serverLevel != null);
            exactSpawnPosition = VectorHelper.convertToVec3(serverLevel.m_8900_());
        }
        return new Pair(exactSpawnPosition, (Object)serverLevel);
    }

    public static void teleportToSpawnPosition(ServerPlayer player) {
        Pair<Vec3, ServerLevel> spawnData = LevelHelper.getSpawnData(player);
        Vec3 spawnPosition = (Vec3)spawnData.getFirst();
        ServerLevel serverLevel = (ServerLevel)spawnData.getSecond();
        player.m_8999_(serverLevel, spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_, player.m_146908_(), player.m_146909_());
    }

    public static boolean teleportNearby(LivingEntity target, ServerLevel level, double offset) {
        boolean isEntityInside;
        boolean bl = isEntityInside = target.f_19791_ + 8.0 > (double)level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)target.f_19790_, (int)target.f_19792_);
        if (isEntityInside) {
            offset /= 2.0;
        }
        Vec3 newPosition = Random.getRandomVector3d(-offset, offset, -1.0, 1.0, -offset, offset).m_82549_(target.m_20182_());
        double y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)newPosition.f_82479_, (int)newPosition.f_82481_) + 1;
        if (!(y < -45.0) && target.m_20984_(newPosition.f_82479_, target.f_19791_ + 8.0 > y ? y : newPosition.f_82480_, newPosition.f_82481_, true)) {
            level.m_6263_(null, target.f_19854_, target.f_19855_, target.f_19856_, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, target.f_19854_, target.m_20227_(0.5), target.f_19856_, 10, 0.25, 0.25, 0.25, 0.1);
            return true;
        }
        return false;
    }

    public static void freezeWater(LivingEntity entity, double radius, int minimumIceDuration, int maximumIceDuration) {
        LevelHelper.freezeWater(entity, radius, minimumIceDuration, maximumIceDuration, true);
    }

    public static void freezeWater(LivingEntity entity, double radius, int minimumIceDuration, int maximumIceDuration, boolean requireOnGround) {
        if (requireOnGround && !entity.m_20096_()) {
            return;
        }
        BlockState iceBlockState = Blocks.f_50449_.m_49966_();
        BlockPos entityPosition = entity.m_142538_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        Iterable blocksInRange = BlockPos.m_121940_((BlockPos)entityPosition.m_142022_(-radius, -1.0, -radius), (BlockPos)entityPosition.m_142022_(radius, -1.0, radius));
        for (BlockPos blockPos : blocksInRange) {
            if (!blockPos.m_123314_((Vec3i)entityPosition, radius)) continue;
            mutableBlockPos.m_122178_(blockPos.m_123341_(), blockPos.m_123342_() + 1, blockPos.m_123343_());
            BlockState blockState = entity.f_19853_.m_8055_((BlockPos)mutableBlockPos);
            if (!blockState.m_60795_()) continue;
            BlockState blockState2 = entity.f_19853_.m_8055_(blockPos);
            boolean isWater = blockState2.m_60767_() == Material.f_76305_;
            boolean isFull = blockState2.m_60734_() == Blocks.f_49990_ && (Integer)blockState2.m_61143_((Property)LiquidBlock.f_54688_) == 0;
            boolean canSurvive = iceBlockState.m_60710_((LevelReader)entity.f_19853_, blockPos);
            boolean isUnobstructed = entity.f_19853_.m_45752_(iceBlockState, blockPos, CollisionContext.m_82749_());
            if (!isWater || !isFull || !canSurvive || !isUnobstructed || ForgeEventFactory.onBlockPlace((Entity)entity, (BlockSnapshot)BlockSnapshot.create((ResourceKey)entity.f_19853_.m_46472_(), (LevelAccessor)entity.f_19853_, (BlockPos)blockPos), (Direction)Direction.UP)) continue;
            entity.f_19853_.m_46597_(blockPos, iceBlockState);
            entity.f_19853_.m_186460_(blockPos, Blocks.f_50449_, Mth.m_14072_((java.util.Random)entity.m_21187_(), (int)60, (int)120));
        }
    }

    public static void spawnItemEntityFlyingTowardsDirection(ItemStack itemStack, Level level, Vec3 from, Vec3 to) {
        Vec3 spawnPosition = VectorHelper.add(from, Random.getRandomVector3d(-0.25, 0.25, 0.125, 0.5, -0.25, 0.25));
        Vec3 motion = VectorHelper.multiply(VectorHelper.subtract(to, spawnPosition), 0.1);
        ItemEntity itemEntity = new ItemEntity(level, spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_, itemStack);
        itemEntity.m_20256_(VectorHelper.add(motion, new Vec3(0.0, Math.pow(VectorHelper.length(motion), 0.5) * 0.25, 0.0)));
        level.m_7967_((Entity)itemEntity);
    }
}

