/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.commands;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.commands.ChangeGameStageCommand;
import com.majruszsdifficulty.commands.GetClampedRegionalDifficultyCommands;
import com.majruszsdifficulty.commands.GetGameStageCommand;
import com.majruszsdifficulty.commands.HighlightUndeadArmyCommands;
import com.majruszsdifficulty.commands.KillUndeadArmyCommands;
import com.majruszsdifficulty.commands.StartUndeadArmyCommands;
import com.majruszsdifficulty.commands.StopUndeadArmyCommands;
import com.majruszsdifficulty.commands.TreasureBagResetProgressCommands;
import com.majruszsdifficulty.commands.UndeadArmyProgressCommands;
import com.majruszsdifficulty.commands.UndeadArmyUndeadLeftCommands;
import com.mlib.commands.BaseCommand;
import com.mlib.commands.IRegistrableCommand;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.phys.Vec3;

public class CommandsHelper {
    public static final List<IRegistrableCommand> COMMANDS = new ArrayList<IRegistrableCommand>();
    public static final LiteralArgumentBuilder<CommandSourceStack> UNDEAD_ARMY_ARGUMENT = BaseCommand.literal((String)"undeadarmy");
    public static final LiteralArgumentBuilder<CommandSourceStack> TREASURE_BAG_ARGUMENT = BaseCommand.literal((String)"treasurebag");

    public static MutableComponent createGameStageMessage(GameStage.Stage stage, String translationID) {
        return new TranslatableComponent("commands.gamestage." + translationID, new Object[]{GameStage.getGameStageText(stage)});
    }

    public static MutableComponent createBaseMessageWithPosition(String translationKey, Vec3 position, Object ... objects) {
        Object[] copy = new Object[objects.length + 1];
        copy[objects.length] = CommandsHelper.getPositionFormatted(position);
        System.arraycopy(objects, 0, copy, 0, objects.length);
        return new TranslatableComponent(translationKey, copy);
    }

    public static String getPositionFormatted(Vec3 position) {
        return String.format("(%d, %d, %d)", (int)position.f_82479_, (int)position.f_82480_, (int)position.f_82481_);
    }

    static {
        COMMANDS.add(new StopUndeadArmyCommands());
        COMMANDS.add(new StartUndeadArmyCommands());
        COMMANDS.add(new KillUndeadArmyCommands());
        COMMANDS.add(new HighlightUndeadArmyCommands());
        COMMANDS.add(new UndeadArmyUndeadLeftCommands());
        COMMANDS.add(new UndeadArmyProgressCommands());
        COMMANDS.add(new ChangeGameStageCommand());
        COMMANDS.add(new GetGameStageCommand());
        COMMANDS.add(new GetClampedRegionalDifficultyCommands());
        COMMANDS.add(new TreasureBagResetProgressCommands());
    }
}

