/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.majruszsdifficulty.gamemodifiers.DifficultyModifier;
import com.majruszsdifficulty.gamemodifiers.configs.BleedingConfig;
import com.mlib.config.UserConfig;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.contexts.OnDamagedContext;
import com.mlib.gamemodifiers.data.OnDamagedData;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;

public class BiteBleeding
extends DifficultyModifier {
    final BleedingConfig bleeding = new BleedingConfig();

    public BiteBleeding() {
        super(DifficultyModifier.DEFAULT, "BiteBleeding", "Animals (wolfs and from other mods), zombies and spiders may inflict bleeding.");
        OnDamagedContext onDamaged = new OnDamagedContext(this::applyBleeding);
        onDamaged.addCondition((Condition)new CustomConditions.GameStage(GameStage.Stage.NORMAL)).addCondition((Condition)new CustomConditions.CRDChance(0.5, false)).addCondition((Condition)new Condition.Excludable()).addCondition((Condition)new Condition.IsLivingBeing()).addCondition((Condition)new Condition.ArmorDependentChance()).addCondition(data -> BiteBleeding.canBite(data.attacker)).addCondition(data -> data.source.m_7640_() == data.attacker).addConfig((UserConfig)this.bleeding);
        this.addContext((Context)onDamaged);
    }

    private void applyBleeding(OnDamagedData data) {
        this.bleeding.apply(data);
    }

    private static boolean canBite(@Nullable LivingEntity attacker) {
        return (attacker instanceof Animal || attacker instanceof Zombie || attacker instanceof Spider) && !(attacker instanceof Llama);
    }
}

