/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.majruszsdifficulty.gamemodifiers.DifficultyModifier;
import com.mlib.Utility;
import com.mlib.config.StringListConfig;
import com.mlib.config.UserConfig;
import com.mlib.effects.ParticleHandler;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.contexts.OnLootContext;
import com.mlib.gamemodifiers.data.OnLootData;
import com.mlib.gamemodifiers.parameters.ContextParameters;
import com.mlib.gamemodifiers.parameters.Priority;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class DoubleLoot
extends DifficultyModifier {
    static final ParticleHandler AWARD = new ParticleHandler(ParticleTypes.f_123748_, new Vec3(0.5, 1.0, 0.5), () -> Float.valueOf(0.1f));
    final StringListConfig forbiddenItems = new StringListConfig("forbidden_items", "List of items that cannot be duplicated.", false, new String[]{"minecraft:nether_star", "minecraft:totem_of_undying"});

    public DoubleLoot() {
        super(DifficultyModifier.DEFAULT, "DoubleLoot", "Gives a chance to double the loot.");
        this.generateContext(0.0, GameStage.Stage.NORMAL, "NormalMode", "Determines the chance on Normal Mode.");
        this.generateContext(0.2, GameStage.Stage.EXPERT, "ExpertMode", "Determines the chance on Expert Mode.");
        this.generateContext(0.4, GameStage.Stage.MASTER, "MasterMode", "Determines the chance on Master Mode.");
        this.addConfig((UserConfig)this.forbiddenItems);
    }

    private void generateContext(double chance, GameStage.Stage stage, String configName, String configComment) {
        OnLootContext onLootContext = new OnLootContext(this::doubleLoot, new ContextParameters(Priority.NORMAL, configName, configComment));
        onLootContext.addCondition((Condition)new CustomConditions.GameStageExact(stage)).addCondition((Condition)new CustomConditions.CRDChance(chance, false)).addCondition(OnLootContext.HAS_LAST_DAMAGE_PLAYER).addCondition(OnLootContext.HAS_ENTITY);
        this.addContext((Context)onLootContext);
    }

    private void doubleLoot(OnLootData data) {
        assert (data.entity != null && data.lastDamagePlayer != null);
        boolean doubledAtLeastOneItem = this.replaceLoot(data.generatedLoot);
        if (doubledAtLeastOneItem && data.level != null) {
            AWARD.spawn(data.level, data.entity.m_20182_().m_82520_(0.0, 0.5, 0.0), 12);
        }
    }

    private boolean replaceLoot(List<ItemStack> generatedLoot) {
        boolean doubledAtLeastOneItem = false;
        ArrayList<ItemStack> doubledLoot = new ArrayList<ItemStack>();
        for (ItemStack itemStack : generatedLoot) {
            doubledLoot.add(itemStack);
            if (!this.isAllowed(itemStack)) continue;
            doubledLoot.add(itemStack);
            doubledAtLeastOneItem = true;
        }
        generatedLoot.clear();
        generatedLoot.addAll(doubledLoot);
        return doubledAtLeastOneItem;
    }

    private boolean isAllowed(ItemStack itemStack) {
        return !itemStack.m_41619_() && !this.forbiddenItems.contains(Utility.getRegistryString((ItemStack)itemStack));
    }
}

