/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.gamemodifiers.DifficultyModifier;
import com.majruszsdifficulty.gamemodifiers.configs.StageProgressConfig;
import com.mlib.config.BooleanConfig;
import com.mlib.config.EnumConfig;
import com.mlib.config.UserConfig;
import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.contexts.OnDeathContext;
import com.mlib.gamemodifiers.contexts.OnDimensionChangedContext;
import com.mlib.gamemodifiers.data.OnDeathData;
import com.mlib.gamemodifiers.data.OnDimensionChangedData;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;

public class IncreaseGameStage
extends DifficultyModifier {
    static final EnumConfig<GameStage.Stage> DEFAULT_GAME_STAGE = new EnumConfig("default_mode", "Game stage set at the beginning of a new world.", false, (Enum)GameStage.Stage.NORMAL);
    final StageProgressConfig expertMode = new StageProgressConfig("ExpertMode", "Determines what starts the Expert Mode.", "none", "minecraft:the_nether");
    final StageProgressConfig masterMode = new StageProgressConfig("MasterMode", "Determines what starts the Master Mode.", "minecraft:ender_dragon", "none");
    final BooleanConfig enteringAnyDimensionStartsExpertMode = new BooleanConfig("any_dimension_expert", "Determines whether any dimension should start Expert Mode (useful for integration with other mods).", false, true);

    public static GameStage.Stage getDefaultGameStage() {
        return (GameStage.Stage)((Object)DEFAULT_GAME_STAGE.get());
    }

    public IncreaseGameStage() {
        super(DifficultyModifier.GAME_STAGE, "GameStage", "");
        OnDimensionChangedContext onExpertDimension = new OnDimensionChangedContext(this::startExpertMode);
        onExpertDimension.addCondition(data -> GameStage.getCurrentStage() == GameStage.Stage.NORMAL).addCondition(data -> this.expertMode.dimensionTriggersChange(data.to.m_135782_()) || this.enteringAnyDimensionStartsExpertMode.isEnabled());
        OnDimensionChangedContext onMasterDimension = new OnDimensionChangedContext(this::startMasterMode);
        onMasterDimension.addCondition(data -> GameStage.getCurrentStage() == GameStage.Stage.EXPERT).addCondition(data -> this.masterMode.dimensionTriggersChange(data.to.m_135782_()));
        OnDeathContext onExpertKill = new OnDeathContext(this::startExpertMode);
        onExpertKill.addCondition(data -> GameStage.getCurrentStage() == GameStage.Stage.NORMAL).addCondition(data -> this.expertMode.entityTriggersChange(EntityType.m_20613_((EntityType)data.target.m_6095_())));
        OnDeathContext onMasterKill = new OnDeathContext(this::startMasterMode);
        onMasterKill.addCondition(data -> GameStage.getCurrentStage() == GameStage.Stage.EXPERT).addCondition(data -> this.masterMode.entityTriggersChange(EntityType.m_20613_((EntityType)data.target.m_6095_())));
        this.addContexts(new Context[]{onExpertDimension, onMasterDimension, onExpertKill, onMasterKill});
        this.addConfigs(new UserConfig[]{DEFAULT_GAME_STAGE, this.enteringAnyDimensionStartsExpertMode, this.expertMode, this.masterMode});
    }

    private void startExpertMode(OnDimensionChangedData data) {
        this.startExpertMode(data.entity.m_20194_());
    }

    private void startExpertMode(OnDeathData data) {
        this.startExpertMode(data.target.m_20194_());
    }

    private void startExpertMode(@Nullable MinecraftServer minecraftServer) {
        if (minecraftServer == null) {
            return;
        }
        GameStage.changeModeWithAdvancement(GameStage.Stage.EXPERT, minecraftServer);
        IncreaseGameStage.sendMessageToAllPlayers(minecraftServer.m_6846_(), "majruszsdifficulty.on_expert_mode_start", GameStage.EXPERT_MODE_COLOR);
    }

    private void startMasterMode(OnDimensionChangedData data) {
        this.startMasterMode(data.entity.m_20194_());
    }

    private void startMasterMode(OnDeathData data) {
        this.startMasterMode(data.target.m_20194_());
    }

    private void startMasterMode(@Nullable MinecraftServer minecraftServer) {
        if (minecraftServer == null) {
            return;
        }
        GameStage.changeModeWithAdvancement(GameStage.Stage.MASTER, minecraftServer);
        IncreaseGameStage.sendMessageToAllPlayers(minecraftServer.m_6846_(), "majruszsdifficulty.on_master_mode_start", GameStage.MASTER_MODE_COLOR);
    }

    private static void sendMessageToAllPlayers(PlayerList playerList, String translationKey, ChatFormatting textColor) {
        for (Player player : playerList.m_11314_()) {
            TranslatableComponent message = new TranslatableComponent(translationKey);
            message.m_130944_(new ChatFormatting[]{textColor, ChatFormatting.BOLD});
            player.m_5661_((Component)message, false);
        }
    }
}

