/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.goals;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;

public class UndeadAttackPositionGoal
extends Goal {
    protected final Mob undead;
    protected final BlockPos attackPosition;
    protected final double speedModifier;
    protected final float maxDistanceFromPosition;
    protected final float stopDistance;
    private final PathNavigation navigation;
    protected int ticksToRecalculatePath;

    public UndeadAttackPositionGoal(Mob undead, BlockPos attackPosition, double speedModifier, float maxDistanceFromPosition, float stopDistance) {
        this.undead = undead;
        this.navigation = undead.m_21573_();
        this.attackPosition = attackPosition;
        this.speedModifier = speedModifier;
        this.maxDistanceFromPosition = maxDistanceFromPosition;
        this.stopDistance = stopDistance;
        this.ticksToRecalculatePath = 0;
    }

    public boolean m_8036_() {
        return !this.isInRadius() && !this.hasAnyTarget();
    }

    public boolean m_8045_() {
        return !this.isInRadius() && !this.navigation.m_26571_() && !this.hasAnyTarget();
    }

    public void m_8056_() {
        this.ticksToRecalculatePath = 0;
    }

    public void m_8037_() {
        if (--this.ticksToRecalculatePath > 0) {
            return;
        }
        this.ticksToRecalculatePath = 10;
        this.navigation.m_26519_((double)this.attackPosition.m_123341_(), (double)this.attackPosition.m_123342_(), (double)this.attackPosition.m_123343_(), this.speedModifier);
    }

    protected boolean isInRadius() {
        return this.getDistanceToAttackPosition() < (double)this.maxDistanceFromPosition;
    }

    protected boolean hasAnyTarget() {
        return this.undead.m_5448_() != null || this.undead.m_142581_() != null;
    }

    protected double getDistanceToAttackPosition() {
        return Math.sqrt(Math.pow(this.undead.m_20185_() - (double)this.attackPosition.m_123341_(), 2.0) + Math.pow(this.undead.m_20189_() - (double)this.attackPosition.m_123343_(), 2.0));
    }
}

