/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.itemsets;

import com.majruszsdifficulty.itemsets.BaseSet;
import com.majruszsdifficulty.itemsets.Parameter;
import com.mlib.ObfuscationGetter;
import com.mlib.Utility;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;

public class BonusData {
    static final ObfuscationGetter.Field<TranslatableComponent, List<FormattedText>> DECOMPOSED_PARTS = new ObfuscationGetter.Field(TranslatableComponent.class, "f_131301_");
    static final ObfuscationGetter.Method<TranslatableComponent> DECOMPOSE = new ObfuscationGetter.Method(TranslatableComponent.class, "m_131330_", new Class[0]);
    public final int requiredItems;
    public final String translationKey;
    public final ICondition condition;
    public final Parameter[] parameters;

    public BonusData(int requiredItems, String translationKey, ICondition condition, Parameter ... parameters) {
        this.requiredItems = requiredItems;
        this.translationKey = translationKey;
        this.condition = condition.and((set, player) -> set.countSetItems(player) >= requiredItems);
        this.parameters = parameters;
    }

    public BonusData(int requiredItems, String translationKey, Parameter ... parameters) {
        this(requiredItems, translationKey, (BaseSet set, Player player) -> set.countSetItems(player) >= requiredItems, parameters);
    }

    public BonusData(int requiredItems, String translationKey) {
        this(requiredItems, translationKey, (BaseSet set, Player player) -> set.countSetItems(player) >= requiredItems, new Parameter[0]);
    }

    public MutableComponent createTranslatedText(ChatFormatting defaultFormatting, ChatFormatting valueFormatting) {
        MutableComponent component = new TextComponent("").m_130940_(valueFormatting);
        ArrayList<String> params = new ArrayList<String>();
        for (Parameter parameter : this.parameters) {
            params.add(parameter.getFormat());
        }
        TranslatableComponent TranslatableComponent2 = new TranslatableComponent(this.translationKey, params.toArray());
        DECOMPOSE.invoke((Object)TranslatableComponent2, new Object[0]);
        List formattedTexts = (List)DECOMPOSED_PARTS.get((Object)TranslatableComponent2);
        assert (formattedTexts != null);
        for (int i = 0; i < formattedTexts.size(); ++i) {
            ChatFormatting format = i % 2 == 1 && i / 2 < this.parameters.length ? valueFormatting : defaultFormatting;
            component.m_7220_((Component)new TextComponent(((FormattedText)formattedTexts.get(i)).getString()).m_130940_(format));
        }
        return component;
    }

    public int asInt(@Nonnegative int parameterIdx) {
        return this.parameters[parameterIdx].asInt();
    }

    public float asFloat(@Nonnegative int parameterIdx) {
        return this.parameters[parameterIdx].asFloat();
    }

    public int asTicks(@Nonnegative int parameterIdx) {
        return Utility.secondsToTicks((double)this.parameters[parameterIdx].asFloat());
    }

    public static interface ICondition {
        public boolean validate(BaseSet var1, Player var2);

        default public ICondition and(ICondition otherCondition) {
            return (set, player) -> this.validate(set, player) && otherCondition.validate(set, player);
        }

        default public ICondition or(ICondition otherCondition) {
            return (set, player) -> this.validate(set, player) || otherCondition.validate(set, player);
        }
    }
}

