/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.treasurebags;

import com.majruszsdifficulty.items.TreasureBagItem;
import com.majruszsdifficulty.treasurebags.LootData;
import com.mlib.Utility;
import com.mlib.client.ClientHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LootProgressClient {
    private static final Map<String, List<Component>> TREASURE_BAG_COMPONENTS = new HashMap<String, List<Component>>();
    private static final Map<String, Tuple<Integer, Integer>> UNLOCKED_LOOT = new HashMap<String, Tuple<Integer, Integer>>();
    private static final String HINT_TOOLTIP_TRANSLATION_KEY = "majruszsdifficulty.treasure_bag.hint_tooltip";
    private static final String LIST_TOOLTIP_TRANSLATION_KEY = "majruszsdifficulty.treasure_bag.list_tooltip";

    public static void generateComponents(String treasureBagID, List<LootData> lootDataList) {
        TREASURE_BAG_COMPONENTS.remove(treasureBagID);
        UNLOCKED_LOOT.remove(treasureBagID);
        int unlockedItems = 0;
        int totalItems = 0;
        ArrayList<TextComponent> tooltip = new ArrayList<TextComponent>();
        for (LootData lootData : lootDataList) {
            TextComponent component = new TextComponent(" ");
            if (lootData.isUnlocked) {
                MutableComponent mutableComponent = ((Item)Registry.f_122827_.m_7745_(new ResourceLocation(lootData.itemID))).m_41466_().m_6881_();
                component.m_7220_((Component)mutableComponent.m_130940_(LootProgressClient.getUnlockedItemFormat(lootData.quality)));
            } else {
                component.m_7220_((Component)new TextComponent("???").m_130940_(LootProgressClient.getLockedItemFormat(lootData.quality)));
            }
            if (lootData.isUnlocked) {
                ++unlockedItems;
            }
            ++totalItems;
            tooltip.add(component);
        }
        UNLOCKED_LOOT.put(treasureBagID, (Tuple<Integer, Integer>)new Tuple((Object)unlockedItems, (Object)totalItems));
        TREASURE_BAG_COMPONENTS.put(treasureBagID, tooltip);
    }

    public static void addDropList(TreasureBagItem treasureBagItem, List<Component> tooltip) {
        if (ClientHelper.isShiftDown()) {
            String bagID = Utility.getRegistryString((Item)treasureBagItem);
            if (bagID == null) {
                return;
            }
            Tuple<Integer, Integer> tuple = UNLOCKED_LOOT.get(bagID);
            tooltip.add((Component)new TranslatableComponent(LIST_TOOLTIP_TRANSLATION_KEY, new Object[]{tuple.m_14418_(), tuple.m_14419_()}).m_130940_(ChatFormatting.GRAY));
            if (TREASURE_BAG_COMPONENTS.containsKey(bagID)) {
                tooltip.addAll((Collection<Component>)TREASURE_BAG_COMPONENTS.get(bagID));
            }
        } else {
            tooltip.add((Component)new TranslatableComponent(HINT_TOOLTIP_TRANSLATION_KEY).m_130940_(ChatFormatting.GRAY));
        }
    }

    protected static ChatFormatting getUnlockedItemFormat(int quality) {
        return switch (quality) {
            case 4 -> ChatFormatting.GOLD;
            case 3 -> ChatFormatting.LIGHT_PURPLE;
            case 2 -> ChatFormatting.BLUE;
            case 1 -> ChatFormatting.GREEN;
            default -> ChatFormatting.GRAY;
        };
    }

    protected static ChatFormatting getLockedItemFormat(int quality) {
        return switch (quality) {
            case 4 -> ChatFormatting.GOLD;
            case 3 -> ChatFormatting.DARK_PURPLE;
            case 2 -> ChatFormatting.BLUE;
            case 1 -> ChatFormatting.DARK_GREEN;
            default -> ChatFormatting.DARK_GRAY;
        };
    }
}

