/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.triggers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.items.TreasureBagItem;
import com.mlib.Utility;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;

public class TreasureBagTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = Registries.getLocation("treasure_bag_opened");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public Instance createInstance(JsonObject jsonObject, EntityPredicate.Composite predicate, DeserializationContext conditions) {
        JsonElement bagID = jsonObject.get("bag_id");
        JsonElement amountOfBags = jsonObject.get("amount");
        return new Instance(predicate, bagID.getAsString(), amountOfBags.getAsInt());
    }

    public void trigger(ServerPlayer player, TreasureBagItem item, int amountOfBags) {
        this.m_66234_(player, instance -> instance.test(item, amountOfBags));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final String bagID;
        private final int amountOfBags;

        public Instance(EntityPredicate.Composite predicate, String bagID, int amountOfBags) {
            super(ID, predicate);
            this.bagID = bagID;
            this.amountOfBags = amountOfBags;
        }

        public JsonObject m_7683_(SerializationContext conditions) {
            JsonObject jsonObject = super.m_7683_(conditions);
            jsonObject.addProperty("bag_id", this.bagID);
            jsonObject.addProperty("amount", (Number)this.amountOfBags);
            return jsonObject;
        }

        public boolean test(TreasureBagItem item, int amountOfBags) {
            return amountOfBags >= this.amountOfBags && Utility.getRegistryString((Item)item).equals(this.bagID);
        }
    }
}

