/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.mlib.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public enum Direction {
    WEST(-1, 0),
    EAST(1, 0),
    NORTH(0, -1),
    SOUTH(0, 1);

    private static final int DISTANCE_MULTIPLIER = 10;
    private final int xFactor;
    private final int zFactor;
    public final int x;
    public final int z;

    private Direction(int x, int z) {
        this.x = x;
        this.z = z;
        this.xFactor = (this.z != 0 ? 5 : 1) * 10;
        this.zFactor = (this.x != 0 ? 5 : 1) * 10;
    }

    public static Direction getRandom() {
        return Direction.values()[Random.nextInt((int)0, (int)Direction.values().length)];
    }

    public static Direction getByName(String name) {
        for (Direction direction : Direction.values()) {
            if (!name.equalsIgnoreCase(direction.name())) continue;
            return direction;
        }
        return WEST;
    }

    public BlockPos getRandomSpawnPosition(ServerLevel world, BlockPos positionToAttack, int spawnRadius) {
        int z;
        Vec3 offset;
        int x;
        int y;
        int tries = 0;
        do {
            offset = Random.getRandomVector3d((double)(-this.xFactor), (double)this.xFactor, (double)0.0, (double)0.0, (double)(-this.zFactor), (double)this.zFactor);
        } while ((y = world.m_6924_(Heightmap.Types.MOTION_BLOCKING, x = positionToAttack.m_123341_() + this.x * spawnRadius + (int)offset.f_82479_, z = positionToAttack.m_123343_() + this.z * spawnRadius + (int)offset.f_82481_)) != world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) && ++tries < 5);
        return new BlockPos(x, y + 1, z);
    }
}

