/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.google.common.collect.Sets;
import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.entities.TankEntity;
import com.majruszsdifficulty.goals.ForgiveUndeadArmyTargetGoal;
import com.majruszsdifficulty.goals.UndeadAttackPositionGoal;
import com.majruszsdifficulty.items.TreasureBagItem;
import com.majruszsdifficulty.items.UndeadArmorItem;
import com.majruszsdifficulty.undeadarmy.Direction;
import com.majruszsdifficulty.undeadarmy.Status;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import com.majruszsdifficulty.undeadarmy.UndeadArmyManager;
import com.majruszsdifficulty.undeadarmy.UndeadArmyText;
import com.majruszsdifficulty.undeadarmy.WaveMembersConfig;
import com.mlib.Random;
import com.mlib.Utility;
import com.mlib.effects.EffectHelper;
import com.mlib.items.ItemHelper;
import com.mlib.nbt.NBTHelper;
import com.mlib.time.TimeHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class UndeadArmy {
    private static final int SAFE_SPAWN_RADIUS = 90;
    private static final int SPAWN_RADIUS = 70;
    private final ServerLevel level;
    private final ServerBossEvent bossInfo = new ServerBossEvent((Component)UndeadArmyText.TITLE, BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_10);
    private final List<Pair<BlockPos, EntityType<?>>> spawnInfoList = new ArrayList();
    private final BlockPos positionToAttack;
    private final Direction direction;
    private Status status;
    private boolean isActive;
    private int ticksActive;
    private int ticksInactive;
    private final int ticksInactiveMaximum;
    private int ticksWaveActive;
    private int ticksBetweenWaves;
    private final int ticksBetweenWavesMaximum;
    private int currentWave;
    private int undeadToKill;
    private int undeadKilled;

    public UndeadArmy(ServerLevel level, BlockPos positionToAttack, Direction direction) {
        this.level = level;
        this.positionToAttack = positionToAttack;
        this.direction = direction;
        this.status = Status.BETWEEN_WAVES;
        this.isActive = true;
        this.ticksActive = 0;
        this.ticksInactive = 0;
        this.ticksWaveActive = 0;
        this.ticksBetweenWaves = 0;
        this.currentWave = 0;
        this.undeadToKill = 1;
        this.undeadKilled = 0;
        this.ticksBetweenWaves = this.ticksBetweenWavesMaximum = UndeadArmyConfig.getTicksBetweenWaves();
        this.ticksInactiveMaximum = UndeadArmyConfig.getInactivityTicks();
        this.bossInfo.m_142711_(0.0f);
        this.generateSpawnInfo();
    }

    public UndeadArmy(ServerLevel level, CompoundTag nbt) {
        this.level = level;
        this.positionToAttack = NBTHelper.loadBlockPos((CompoundTag)nbt, (String)"UndeadArmyPosition");
        this.direction = Direction.getByName(nbt.m_128461_("Direction"));
        this.status = Status.getByName(nbt.m_128461_("Status"));
        this.isActive = nbt.m_128471_("IsActive");
        this.ticksActive = nbt.m_128451_("TicksActive");
        this.ticksInactive = nbt.m_128451_("TicksInactive");
        this.ticksWaveActive = nbt.m_128451_("TicksWaveActive");
        this.ticksBetweenWaves = nbt.m_128451_("BetweenRaidTick");
        this.currentWave = nbt.m_128451_("CurrentWave");
        this.undeadToKill = nbt.m_128451_("UndeadToKill");
        this.undeadKilled = nbt.m_128451_("UndeadKilled");
        this.ticksBetweenWaves = this.ticksBetweenWavesMaximum = UndeadArmyConfig.getTicksBetweenWaves();
        this.ticksInactiveMaximum = UndeadArmyConfig.getInactivityTicks();
        this.updateProgressBarText();
        if (this.status == Status.BETWEEN_WAVES) {
            this.generateSpawnInfo();
        }
    }

    public CompoundTag write(CompoundTag nbt) {
        NBTHelper.saveBlockPos((CompoundTag)nbt, (String)"UndeadArmyPosition", (BlockPos)this.positionToAttack);
        nbt.m_128359_("Direction", String.valueOf((Object)this.direction));
        nbt.m_128359_("Status", String.valueOf((Object)this.status));
        nbt.m_128379_("IsActive", this.isActive);
        nbt.m_128405_("TicksActive", this.ticksActive);
        nbt.m_128405_("TicksInactive", this.ticksInactive);
        nbt.m_128405_("TicksWaveActive", this.ticksWaveActive);
        nbt.m_128405_("BetweenRaidTick", this.ticksBetweenWaves);
        nbt.m_128405_("CurrentWave", this.currentWave);
        nbt.m_128405_("UndeadToKill", this.undeadToKill);
        nbt.m_128405_("UndeadKilled", this.undeadKilled);
        return nbt;
    }

    public BlockPos getAttackedPosition() {
        return this.positionToAttack;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean hasEnded() {
        return !this.isActive;
    }

    public void updateProgressBarText() {
        switch (this.status) {
            case ONGOING: {
                this.bossInfo.m_6456_((Component)(this.currentWave == 0 ? UndeadArmyText.TITLE : UndeadArmyText.constructWaveMessage(this.currentWave)));
                break;
            }
            case BETWEEN_WAVES: {
                this.bossInfo.m_6456_((Component)UndeadArmyText.BETWEEN_WAVES);
                break;
            }
            case VICTORY: {
                this.bossInfo.m_6456_((Component)UndeadArmyText.VICTORY);
                break;
            }
            case FAILED: {
                this.bossInfo.m_6456_((Component)UndeadArmyText.FAILED);
            }
        }
    }

    public void tick() {
        if (this.hasEnded()) {
            return;
        }
        if (this.ticksActive++ == 0) {
            MutableComponent message = UndeadArmyText.constructDirectionMessage(this.direction);
            List<ServerPlayer> players = this.getNearbyPlayers();
            players.forEach(player -> player.m_5661_((Component)message, false));
        }
        if (TimeHelper.hasServerSecondsPassed((double)1.0)) {
            this.updateUndeadArmyBarVisibility();
        }
        switch (this.status) {
            case BETWEEN_WAVES: {
                this.tickBetweenWaves();
                break;
            }
            case ONGOING: {
                this.tickOngoing();
                break;
            }
            case VICTORY: 
            case FAILED: {
                this.tickFinished();
                break;
            }
            case STOPPED: {
                this.tickStopped();
            }
        }
    }

    public void increaseUndeadCounter() {
        this.undeadKilled = Math.min(this.undeadKilled + 1, this.undeadToKill);
    }

    public void highlightArmy() {
        for (Mob monster : this.getArmyMobs()) {
            EffectHelper.applyEffectIfPossible((LivingEntity)monster, (MobEffect)MobEffects.f_19619_, (int)Utility.secondsToTicks((double)15.0), (int)5);
        }
    }

    public int countMobsLeft() {
        return this.countArmyMobs();
    }

    public void finish() {
        this.isActive = false;
        this.bossInfo.m_7706_();
    }

    public void killAllUndeadArmyMobs() {
        this.undeadKilled = this.undeadToKill;
        List<Mob> mobs = this.getArmyMobs();
        mobs.forEach(mob -> mob.m_6469_(DamageSource.f_19319_, 9001.0f));
    }

    public void addUndeadArmyAI(Mob monster) {
        float speedModifier = monster instanceof TankEntity ? 1.5f : 1.25f;
        monster.f_21345_.m_25352_(4, (Goal)new UndeadAttackPositionGoal(monster, this.getAttackedPosition(), speedModifier, 20.0f, 3.0f));
        PathfinderMob pathfinderMob = (PathfinderMob)Utility.castIfPossible(PathfinderMob.class, (Object)monster);
        if (pathfinderMob != null) {
            monster.f_21346_.m_148105_().removeIf(wrappedGoal -> wrappedGoal.m_26015_() instanceof HurtByTargetGoal);
            monster.f_21346_.m_25352_(1, (Goal)new ForgiveUndeadArmyTargetGoal(pathfinderMob, new Class[0]));
        }
    }

    private void tickBetweenWaves() {
        if (this.ticksBetweenWaves-- <= 0) {
            this.proceedToNextWave();
        }
        this.bossInfo.m_142711_(Mth.m_14036_((float)(1.0f - (float)this.ticksBetweenWaves / (float)this.ticksBetweenWavesMaximum), (float)0.0f, (float)1.0f));
        this.spawnInfoList.forEach(spawnInfo -> {
            BlockPos position = (BlockPos)spawnInfo.getFirst();
            this.level.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)position.m_123341_() + 0.5, (double)position.m_123342_(), (double)position.m_123343_() + 0.5, 2, 0.5, 0.5, 0.5, 0.02);
        });
    }

    private void tickOngoing() {
        if (this.countNearbyPlayers() == 0) {
            this.status = Status.STOPPED;
        }
        if (this.shouldWaveEndPrematurely()) {
            this.killAllUndeadArmyMobs();
        }
        if (this.undeadKilled == this.undeadToKill) {
            this.endWave();
        }
        if (this.shouldMobsBeHighlighted()) {
            this.highlightArmy();
        }
        ++this.ticksWaveActive;
        this.bossInfo.m_142711_(Mth.m_14036_((float)(1.0f - (float)this.undeadKilled / (float)this.undeadToKill), (float)0.0f, (float)1.0f));
    }

    private void tickFinished() {
        if (--this.ticksBetweenWaves <= 0) {
            this.finish();
        }
    }

    private void tickStopped() {
        if (this.countNearbyPlayers() > 0) {
            this.status = Status.ONGOING;
        }
        if (this.ticksInactive++ >= this.ticksInactiveMaximum) {
            this.status = Status.FAILED;
            this.ticksBetweenWaves = this.ticksBetweenWavesMaximum * 2;
            this.bossInfo.m_142711_(1.0f);
        }
    }

    private void proceedToNextWave() {
        ++this.currentWave;
        this.status = Status.ONGOING;
        this.ticksWaveActive = 0;
        this.spawnWaveEnemies();
        this.updateProgressBarText();
    }

    private void endWave() {
        if (this.currentWave >= UndeadArmyConfig.getWavesCount()) {
            this.status = Status.VICTORY;
            this.ticksBetweenWaves = this.ticksBetweenWavesMaximum * 2;
            this.rewardPlayers();
            this.bossInfo.m_142711_(1.0f);
        } else {
            this.status = Status.BETWEEN_WAVES;
            this.ticksBetweenWaves = this.ticksBetweenWavesMaximum;
            this.generateSpawnInfo();
        }
        this.updateProgressBarText();
    }

    private void generateSpawnInfo() {
        this.spawnInfoList.clear();
        UndeadArmyConfig.getWaveMembers(this.currentWave + 1).forEach(waveMember -> {
            int totalAmount = this.getTotalAmount((WaveMembersConfig.WaveMember)waveMember);
            for (int i = 0; i < totalAmount; ++i) {
                this.spawnInfoList.add(new Pair((Object)this.direction.getRandomSpawnPosition(this.level, this.positionToAttack, 70), waveMember.entityType()));
            }
        });
    }

    private int getTotalAmount(WaveMembersConfig.WaveMember waveMember) {
        return (int)((double)waveMember.amount() * UndeadArmyConfig.getSizeMultiplier(this.countNearbyPlayers()));
    }

    private void spawnWaveEnemies() {
        this.undeadToKill = 0;
        this.undeadKilled = 0;
        for (Pair<BlockPos, EntityType<?>> spawnInfo : this.spawnInfoList) {
            BlockPos randomPosition = (BlockPos)spawnInfo.getFirst();
            EntityType entityType = (EntityType)spawnInfo.getSecond();
            Entity entity = entityType.m_20655_(this.level, null, null, null, randomPosition, MobSpawnType.EVENT, true, true);
            if (!(entity instanceof Mob)) continue;
            Mob monster = (Mob)entity;
            monster.m_21530_();
            this.addUndeadArmyAI(monster);
            this.equipWithUndeadArmyArmor(monster);
            this.tryToEnchantEquipment(monster);
            this.markAsUndeadArmyMob((LivingEntity)monster);
            if (monster instanceof Skeleton && Random.tryChance((double)UndeadArmyConfig.getSkeletonHorseChance())) {
                this.spawnOnSkeletonHorse(monster);
            }
            monster.m_21553_(false);
            if (ForgeEventFactory.doSpecialSpawn((Mob)monster, (Level)this.level, (float)randomPosition.m_123341_(), (float)randomPosition.m_123342_(), (float)randomPosition.m_123343_(), null, (MobSpawnType)MobSpawnType.EVENT)) continue;
            this.level.m_7967_((Entity)monster);
            ++this.undeadToKill;
        }
        int x = this.positionToAttack.m_123341_() + this.direction.x * 70;
        int z = this.positionToAttack.m_123343_() + this.direction.z * 70;
        for (ServerPlayer player : this.getNearbyPlayers()) {
            player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket((SoundEvent)Registries.UNDEAD_ARMY_WAVE_STARTED.get(), SoundSource.NEUTRAL, (double)x, player.m_20186_(), (double)z, 64.0f, 1.0f));
        }
        this.undeadToKill = Math.max(this.undeadToKill, 1);
    }

    private boolean shouldMobsBeHighlighted() {
        return this.ticksWaveActive >= Utility.minutesToTicks((double)1.5) && this.ticksWaveActive % 100 == 0 && this.undeadKilled > this.undeadToKill / 2;
    }

    private boolean shouldWaveEndPrematurely() {
        boolean thereIsOnlyFewUndeadLeft = (double)this.undeadKilled >= (double)this.undeadToKill * 0.8 && this.countMobsLeft() < 3;
        return thereIsOnlyFewUndeadLeft && this.ticksWaveActive >= Utility.minutesToTicks((double)2.5);
    }

    private void tryToEnchantEquipment(Mob monster) {
        double clampedRegionalDifficulty = GameStage.getRegionalDifficulty((LivingEntity)monster);
        double chanceToEnchant = UndeadArmyConfig.getEnchantedItemChance();
        if (monster.m_21033_(EquipmentSlot.MAINHAND) && Random.tryChance((double)chanceToEnchant)) {
            monster.m_21008_(InteractionHand.MAIN_HAND, ItemHelper.enchantItem((ItemStack)monster.m_21205_(), (double)clampedRegionalDifficulty, (boolean)false));
        }
        for (ItemStack armor : monster.m_6168_()) {
            if (!Random.tryChance((double)(chanceToEnchant / 2.0)) || (armor = ItemHelper.enchantItem((ItemStack)armor, (double)clampedRegionalDifficulty, (boolean)false)).getEquipmentSlot() == null) continue;
            monster.m_8061_(armor.getEquipmentSlot(), armor);
        }
    }

    private void equipWithUndeadArmyArmor(Mob monster) {
        float chanceToEquip = (float)UndeadArmyConfig.getArmorPieceChance();
        float chanceToDrop = 0.015f;
        this.tryToEquipItem(monster, "majruszsdifficulty.items.undead_helmet", 1.0f, chanceToDrop);
        this.tryToEquipItem(monster, "majruszsdifficulty.items.undead_chestplate", chanceToEquip, chanceToDrop);
        this.tryToEquipItem(monster, "majruszsdifficulty.items.undead_leggings", chanceToEquip, chanceToDrop);
        this.tryToEquipItem(monster, "majruszsdifficulty.items.undead_boots", chanceToEquip, chanceToDrop);
    }

    private void tryToEquipItem(Mob monster, String itemId, float chanceToEquip, float chanceToDrop) {
        if (Random.tryChance((double)(1.0 - (double)chanceToEquip)) || monster instanceof TankEntity) {
            return;
        }
        UndeadArmorItem.ItemData itemData = UndeadArmorItem.getData(itemId);
        ItemStack armorPiece = UndeadArmorItem.constructItem(itemId);
        ItemHelper.damageItem((ItemStack)armorPiece, (double)0.75);
        monster.m_21540_(armorPiece);
        monster.m_21409_(itemData.slot(), chanceToDrop);
    }

    private void rewardPlayers() {
        for (ServerPlayer player : this.level.m_8795_(this.getParticipantsPredicate())) {
            Vec3 position = player.m_20182_();
            for (int i = 0; i < UndeadArmyConfig.getAmountOfVictoryExperience() / 4; ++i) {
                this.level.m_7967_((Entity)new ExperienceOrb((Level)this.level, position.f_82479_, position.f_82480_ + 1.0, position.f_82481_, 4));
            }
            Registries.UNDEAD_ARMY_DEFEATED_TRIGGER.trigger(player, this.currentWave);
            if (!((TreasureBagItem)((Object)Registries.UNDEAD_ARMY_TREASURE_BAG.get())).isEnabled()) continue;
            ItemHelper.giveItemStackToPlayer((ItemStack)new ItemStack((ItemLike)Registries.UNDEAD_ARMY_TREASURE_BAG.get()), (Player)player, (ServerLevel)this.level);
        }
    }

    private void markAsUndeadArmyMob(LivingEntity entity) {
        NBTHelper.saveBlockPos((CompoundTag)entity.getPersistentData(), (String)"UndeadArmyPosition", (BlockPos)this.positionToAttack);
    }

    private void spawnOnSkeletonHorse(Mob monster) {
        Level level = monster.f_19853_;
        SkeletonHorse skeletonHorse = (SkeletonHorse)EntityType.f_20525_.m_20615_(level);
        if (skeletonHorse == null) {
            return;
        }
        skeletonHorse.m_146762_(0);
        skeletonHorse.m_6034_(monster.m_20185_(), monster.m_20186_(), monster.m_20189_());
        level.m_7967_((Entity)skeletonHorse);
        monster.m_20329_((Entity)skeletonHorse);
        skeletonHorse.f_21345_.m_25352_(4, (Goal)new UndeadAttackPositionGoal((Mob)skeletonHorse, this.getAttackedPosition(), 1.5, 20.0f, 3.0f));
        this.markAsUndeadArmyMob((LivingEntity)skeletonHorse);
    }

    private void updateUndeadArmyBarVisibility() {
        HashSet currentPlayers = Sets.newHashSet((Iterable)this.bossInfo.m_8324_());
        List<ServerPlayer> validPlayers = this.getNearbyPlayers();
        for (ServerPlayer player : validPlayers) {
            if (currentPlayers.contains(player)) continue;
            this.bossInfo.m_6543_(player);
        }
        for (ServerPlayer player : currentPlayers) {
            if (validPlayers.contains(player)) continue;
            this.bossInfo.m_6539_(player);
        }
    }

    private AABB getAxisAligned(double range) {
        Vec3i vector = new Vec3i(range, range, range);
        return new AABB(this.getAttackedPosition().m_141950_(vector), this.getAttackedPosition().m_141952_(vector));
    }

    private Predicate<Mob> getUndeadParticipantsPredicate() {
        return mob -> mob.m_6084_() && UndeadArmyManager.isUndeadArmy((LivingEntity)mob);
    }

    private List<Mob> getArmyMobs() {
        return this.level.m_6443_(Mob.class, this.getAxisAligned(90.0), this.getUndeadParticipantsPredicate());
    }

    private int countArmyMobs() {
        return this.getArmyMobs().size();
    }

    private Predicate<ServerPlayer> getParticipantsPredicate() {
        return player -> player.m_6084_() && Registries.UNDEAD_ARMY_MANAGER != null && Registries.UNDEAD_ARMY_MANAGER.findNearestUndeadArmy(new BlockPos(player.m_20182_())) == this;
    }

    private List<ServerPlayer> getNearbyPlayers(double range) {
        return this.level.m_6443_(ServerPlayer.class, this.getAxisAligned(range), this.getParticipantsPredicate());
    }

    private List<ServerPlayer> getNearbyPlayers() {
        return this.level.m_8795_(this.getParticipantsPredicate());
    }

    private int countNearbyPlayers(double range) {
        return this.getNearbyPlayers(range).size();
    }

    private int countNearbyPlayers() {
        return this.getNearbyPlayers().size();
    }
}

