/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.undeadarmy.Direction;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import com.mlib.MajruszLibrary;
import com.mlib.Utility;
import com.mlib.levels.LevelHelper;
import com.mlib.time.TimeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.SavedData;

public class UndeadArmyManager
extends SavedData {
    public static final String DATA_NAME = "undead_army";
    static final float MAXIMUM_DISTANCE_TO_ARMY = 12000.0f;
    final List<UndeadArmy> undeadArmies = new ArrayList<UndeadArmy>();
    final List<UndeadArmyToSpawn> undeadArmiesToSpawn = new ArrayList<UndeadArmyToSpawn>();
    final ServerLevel level;

    public static boolean isUndeadArmy(@Nullable LivingEntity entity) {
        return entity != null && !(entity instanceof SkeletonHorse) && entity.getPersistentData().m_128441_("UndeadArmyPositionX");
    }

    public static UndeadArmyManager load(CompoundTag nbt, ServerLevel level) {
        UndeadArmyManager armyManager = new UndeadArmyManager(level);
        ListTag listNBT = nbt.m_128437_("Armies", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            armyManager.undeadArmies.add(new UndeadArmy(armyManager.level, listNBT.m_128728_(i)));
        }
        return armyManager;
    }

    public UndeadArmyManager(ServerLevel level) {
        this.level = level;
    }

    public CompoundTag m_7176_(CompoundTag compoundNBT) {
        ListTag listNBT = new ListTag();
        this.undeadArmies.forEach(undeadArmy -> listNBT.add((Object)undeadArmy.write(new CompoundTag())));
        compoundNBT.m_128365_("Armies", (Tag)listNBT);
        return compoundNBT;
    }

    public void tick() {
        this.undeadArmiesToSpawn.forEach(undeadArmyToSpawn -> {
            undeadArmyToSpawn.tick();
            if (undeadArmyToSpawn.isReadyToSpawn()) {
                this.undeadArmies.add(undeadArmyToSpawn.spawn());
            }
        });
        this.undeadArmiesToSpawn.removeIf(UndeadArmyToSpawn::isReadyToSpawn);
        this.undeadArmies.forEach(UndeadArmy::tick);
        this.undeadArmies.removeIf(UndeadArmy::hasEnded);
        if (TimeHelper.hasServerSecondsPassed((double)10.0)) {
            this.m_77762_();
        }
    }

    public boolean tryToSpawn(Player player) {
        return LevelHelper.isEntityIn((Entity)player, (ResourceKey)Level.f_46428_) && this.tryToSpawn(this.getAttackPosition(player));
    }

    public boolean tryToSpawn(BlockPos attackPosition) {
        return this.tryToSpawn(attackPosition, Optional.empty());
    }

    public boolean tryToSpawn(BlockPos attackPosition, Optional<Direction> optionalDirection) {
        if (this.findNearestUndeadArmy(attackPosition) != null || this.isArmySpawningHere(attackPosition) || !UndeadArmyConfig.isEnabled()) {
            return false;
        }
        Direction direction = optionalDirection.orElseGet(Direction::getRandom);
        this.undeadArmiesToSpawn.add(new UndeadArmyToSpawn(this.level, attackPosition, direction));
        this.level.m_5594_(null, attackPosition, (SoundEvent)Registries.UNDEAD_ARMY_APPROACHING.get(), SoundSource.AMBIENT, 0.25f, 1.0f);
        MajruszLibrary.LOGGER.info("Undead Army started at " + attackPosition + "!");
        return true;
    }

    @Nullable
    public UndeadArmy findNearestUndeadArmy(BlockPos position) {
        UndeadArmy nearestArmy = null;
        double minimumDistance = 12000.0;
        for (UndeadArmy undeadArmy : this.undeadArmies) {
            double distanceToUndeadArmy = position.m_123331_((Vec3i)undeadArmy.getAttackedPosition());
            if (!undeadArmy.isActive() || !(distanceToUndeadArmy < minimumDistance)) continue;
            nearestArmy = undeadArmy;
            minimumDistance = distanceToUndeadArmy;
        }
        return nearestArmy;
    }

    private boolean isArmySpawningHere(BlockPos position) {
        for (UndeadArmyToSpawn undeadArmyToSpawn : this.undeadArmiesToSpawn) {
            if (!undeadArmyToSpawn.isOccupied(position)) continue;
            return true;
        }
        return false;
    }

    private BlockPos getAttackPosition(Player player) {
        BlockPos playerPosition = player.m_142538_();
        int x = playerPosition.m_123341_();
        int z = playerPosition.m_123343_();
        return new BlockPos(x, this.level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z), z);
    }

    public static class UndeadArmyToSpawn {
        final ServerLevel level;
        final BlockPos position;
        final Direction direction;
        int ticksToSpawn;

        public UndeadArmyToSpawn(ServerLevel level, BlockPos position, Direction direction) {
            this.level = level;
            this.position = position;
            this.direction = direction;
            this.ticksToSpawn = Utility.secondsToTicks((double)6.5);
        }

        public UndeadArmy spawn() {
            return new UndeadArmy(this.level, this.position, this.direction);
        }

        public boolean isOccupied(BlockPos position) {
            return this.position.m_123331_((Vec3i)position) < 12000.0;
        }

        public void tick() {
            --this.ticksToSpawn;
        }

        public boolean isReadyToSpawn() {
            return this.ticksToSpawn <= 0;
        }
    }
}

