/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.undeadarmy.UndeadArmyManager;
import com.mlib.Random;
import com.mlib.config.DoubleConfig;
import com.mlib.config.EnumConfig;
import com.mlib.config.UserConfig;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ContextData;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.parameters.Priority;
import com.mlib.math.AABBHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;

public class CustomConditions {

    public static class IsNotTooManyMobsNearby
    extends Condition {
        public IsNotTooManyMobsNearby() {
            super(Priority.LOWEST);
        }

        public boolean check(GameModifier gameModifier, ContextData data) {
            if (data.level == null || data.entity == null) {
                return false;
            }
            return data.level.m_6249_((Entity)data.entity, AABBHelper.createInflatedAABB((Vec3)data.entity.m_20182_(), (double)10.0), entity -> entity instanceof LivingEntity).size() < 15;
        }
    }

    public static class IsNotUndeadArmy
    extends Condition {
        public IsNotUndeadArmy() {
            super(Priority.HIGH);
        }

        public boolean check(GameModifier gameModifier, ContextData data) {
            return !UndeadArmyManager.isUndeadArmy(data.entity);
        }
    }

    public static class IsNotSidekick
    extends Condition {
        public IsNotSidekick() {
            super(Priority.HIGH);
        }

        public boolean check(GameModifier gameModifier, ContextData data) {
            return data.entity instanceof PathfinderMob && !data.entity.getPersistentData().m_128471_("MajruszsDifficultySidekick");
        }
    }

    public static class GameStage
    extends Condition {
        final EnumConfig<GameStage.Stage> minimumStage;

        public GameStage(GameStage.Stage minimumStage) {
            this.minimumStage = new EnumConfig("minimum_stage", "Minimum game stage required for that to happen.", false, (Enum)minimumStage);
            this.addConfig((UserConfig)this.minimumStage);
        }

        public boolean check(GameModifier gameModifier, ContextData data) {
            return com.majruszsdifficulty.GameStage.atLeast((GameStage.Stage)((Object)this.minimumStage.get()));
        }
    }

    public static class CRDChance
    extends Condition {
        final DoubleConfig chance;

        public CRDChance(double defaultChance) {
            super(Priority.HIGH);
            this.chance = new DoubleConfig("chance", "Chance of this to happen (this value is scaled by Clamped Regional Difficulty).", false, defaultChance, 0.0, 1.0);
            this.addConfig((UserConfig)this.chance);
        }

        public boolean check(GameModifier gameModifier, ContextData data) {
            return Random.tryChance((double)(com.majruszsdifficulty.GameStage.getRegionalDifficulty(data.entity) * (Double)this.chance.get()));
        }
    }
}

