/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszsdifficulty.MajruszsHelper;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.effects.BleedingEffect;
import com.majruszsdifficulty.gamemodifiers.GameModifier;
import com.majruszsdifficulty.items.GoldenBandageItem;
import com.mlib.config.ConfigGroup;
import com.mlib.config.UserConfig;
import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.configs.EffectConfig;
import com.mlib.gamemodifiers.contexts.OnPlayerInteractContext;
import com.mlib.gamemodifiers.data.OnPlayerInteractData;
import com.mlib.items.ItemHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BandageItem
extends Item {
    private static final String TOOLTIP_TRANSLATION_KEY_1 = "item.majruszsdifficulty.bandage.item_tooltip1";
    private static final String TOOLTIP_TRANSLATION_KEY_2 = "item.majruszsdifficulty.bandage.item_tooltip2";

    public BandageItem(Rarity rarity) {
        super(new Item.Properties().m_41487_(16).m_41491_(Registries.ITEM_GROUP).m_41497_(rarity));
    }

    public BandageItem() {
        this(Rarity.COMMON);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        MajruszsHelper.addAdvancedTranslatableTexts(tooltip, flag, TOOLTIP_TRANSLATION_KEY_1, TOOLTIP_TRANSLATION_KEY_2);
    }

    public static class BandageUse
    extends GameModifier {
        final EffectConfig regeneration = new EffectConfig("Regeneration", () -> MobEffects.f_19605_, 0, 4.0);
        final EffectConfig goldenRegeneration = new EffectConfig("Regeneration", () -> MobEffects.f_19605_, 1, 4.0);
        final EffectConfig goldenImmunity = new EffectConfig("Immunity", () -> Registries.BLEEDING_IMMUNITY.get(), 0, 60.0);

        public BandageUse() {
            super(GameModifier.DEFAULT, "Bandages", "");
            OnPlayerInteractContext onInteraction = new OnPlayerInteractContext(this::useBandage);
            onInteraction.addCondition(data -> data.itemStack.m_41720_() instanceof BandageItem).addCondition(data -> data.target != null).addCondition(data -> !data.player.f_20911_).addCondition(data -> !(data.event instanceof PlayerInteractEvent.RightClickBlock)).addConfig((UserConfig)new ConfigGroup("Bandage", "Config for a Bandage item.", new UserConfig[]{this.regeneration})).addConfig((UserConfig)new ConfigGroup("GoldenBandage", "Config for a Golden Bandage item.", new UserConfig[]{this.goldenRegeneration, this.goldenImmunity}));
            this.addContext((Context)onInteraction);
        }

        private void useBandage(OnPlayerInteractData data) {
            Villager villager;
            Player player = data.player;
            LivingEntity target = data.target;
            ItemStack itemStack = data.itemStack;
            assert (target != null);
            ItemHelper.consumeItemOnUse((ItemStack)itemStack, (Player)player);
            player.m_21011_(((PlayerInteractEvent)data.event).getHand(), true);
            BandageUse.removeBleeding(itemStack, player, target);
            if (target instanceof Villager && (villager = (Villager)target).m_21023_((MobEffect)Registries.BLEEDING.get())) {
                BandageUse.increaseReputation(villager, player);
            }
            this.applyEffects(itemStack, target);
            BandageUse.playSfx(target);
            ((PlayerInteractEvent)data.event).setCancellationResult(InteractionResult.SUCCESS);
        }

        private void applyEffects(ItemStack itemStack, LivingEntity target) {
            if (itemStack.m_41720_() instanceof GoldenBandageItem) {
                this.goldenRegeneration.apply(target);
                this.goldenImmunity.apply(target);
            } else {
                this.regeneration.apply(target);
            }
        }

        private static void increaseReputation(Villager villager, Player player) {
            villager.m_35517_().m_26191_(player.m_20148_(), GossipType.MINOR_POSITIVE, 5);
        }

        private static void removeBleeding(ItemStack itemStack, Player player, LivingEntity target) {
            BleedingEffect bleeding = (BleedingEffect)((Object)Registries.BLEEDING.get());
            if (target.m_21023_((MobEffect)bleeding) && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Registries.BANDAGE_TRIGGER.trigger(serverPlayer, (BandageItem)itemStack.m_41720_(), target.equals((Object)serverPlayer));
            }
            target.m_21195_((MobEffect)bleeding);
        }

        private static void playSfx(LivingEntity target) {
            target.f_19853_.m_5594_(null, target.m_20183_(), SoundEvents.f_12019_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }
}

