/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.items.CustomArmorMaterial;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public class EnderiumArmorItem
extends ArmorItem {
    private static final String ARMOR_TICK_TAG = "EndArmorTickCounter";

    public EnderiumArmorItem(EquipmentSlot slot) {
        super((ArmorMaterial)CustomArmorMaterial.END, slot, new Item.Properties().m_41491_(Registries.ITEM_GROUP).m_41497_(Rarity.UNCOMMON).m_41486_());
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        CompoundTag data = entity.getPersistentData();
        data.m_128405_(ARMOR_TICK_TAG, (data.m_128451_(ARMOR_TICK_TAG) + 1) % 320);
        Object register = "textures/models/armor/enderium_layer_";
        register = (String)register + (slot == EquipmentSlot.LEGS ? "2" : "1") + "_";
        register = (String)register + (1 + data.m_128451_(ARMOR_TICK_TAG) / 80) + ".png";
        return Registries.getLocationString((String)register);
    }

    public static class Leggings
    extends EnderiumArmorItem {
        public Leggings() {
            super(EquipmentSlot.LEGS);
        }
    }

    public static class Helmet
    extends EnderiumArmorItem {
        public Helmet() {
            super(EquipmentSlot.HEAD);
        }

        public boolean isEnderMask(ItemStack stack, Player player, EnderMan endermanEntity) {
            return Registries.ENDERIUM_SET.countSetItems(player) >= 2;
        }
    }

    public static class Chestplate
    extends EnderiumArmorItem {
        public Chestplate() {
            super(EquipmentSlot.CHEST);
        }
    }

    public static class Boots
    extends EnderiumArmorItem {
        public Boots() {
            super(EquipmentSlot.FEET);
        }
    }
}

