/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class UndeadArmorItem {
    public static final Predicate<ItemStack> IS_SET_ITEM = stack -> stack.m_41783_() != null && stack.m_41783_().m_128471_(NBT_TAG);
    public static final String BOOTS_ID = "majruszsdifficulty.items.undead_boots";
    public static final String CHESTPLATE_ID = "majruszsdifficulty.items.undead_chestplate";
    public static final String HELMET_ID = "majruszsdifficulty.items.undead_helmet";
    public static final String LEGGINGS_ID = "majruszsdifficulty.items.undead_leggings";
    public static final String NBT_TAG = "UndeadArmySet";
    public static final int ARMOR_COLOR = 9595003;

    public static ItemStack constructItem(String id) {
        ItemData itemData = UndeadArmorItem.getData(id);
        ItemStack itemStack = new ItemStack((ItemLike)itemData.item);
        CompoundTag mainTag = itemStack.m_41784_();
        mainTag.m_128379_(NBT_TAG, true);
        itemStack.m_41751_(mainTag);
        CompoundTag displayTag = itemStack.m_41698_("display");
        displayTag.m_128356_("color", 9595003L);
        displayTag.m_128359_("Name", "{\"translate\":\"" + id + "\",\"italic\":false}");
        itemStack.m_41700_("display", (Tag)displayTag);
        return itemStack;
    }

    public static ItemData getData(String id) {
        return switch (id) {
            case BOOTS_ID -> new ItemData(Items.f_42463_, EquipmentSlot.FEET);
            case CHESTPLATE_ID -> new ItemData(Items.f_42408_, EquipmentSlot.CHEST);
            case HELMET_ID -> new ItemData(Items.f_42407_, EquipmentSlot.HEAD);
            case LEGGINGS_ID -> new ItemData(Items.f_42462_, EquipmentSlot.LEGS);
            default -> new ItemData(null, null);
        };
    }

    public record ItemData(Item item, EquipmentSlot slot) {
    }
}

