/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.GameModifier;
import com.majruszsdifficulty.items.CustomItemTier;
import com.mlib.Utility;
import com.mlib.config.UserConfig;
import com.mlib.effects.EffectHelper;
import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.configs.EffectConfig;
import com.mlib.gamemodifiers.contexts.OnDamagedContext;
import com.mlib.gamemodifiers.data.OnDamagedData;
import com.mlib.items.ItemHelper;
import com.mlib.text.TextHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WitherSwordItem
extends SwordItem {
    static final String TOOLTIP_TRANSLATION_KEY = "item.majruszsdifficulty.wither_sword.tooltip";

    public WitherSwordItem() {
        super((Tier)CustomItemTier.WITHER, 3, -2.4f, new Item.Properties().m_41491_(Registries.ITEM_GROUP).m_41497_(Rarity.UNCOMMON));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (!flag.m_7050_()) {
            return;
        }
        String amplifier = TextHelper.toRoman((int)(Effect.WITHER.getAmplifier() + 1));
        String duration = TextHelper.minPrecision((double)Utility.ticksToSeconds((int)Effect.WITHER.getDuration()));
        tooltip.add((Component)Component.m_237110_((String)TOOLTIP_TRANSLATION_KEY, (Object[])new Object[]{amplifier, duration}).m_130940_(ChatFormatting.GRAY));
    }

    public static class Effect
    extends GameModifier {
        static final EffectConfig WITHER = new EffectConfig("", () -> MobEffects.f_19615_, 1, 6.0);

        public Effect() {
            super(GameModifier.DEFAULT, "WitherSwordEffect", "Wither Sword inflicts wither effect.");
            OnDamagedContext onDamaged = new OnDamagedContext(this::applyWither);
            onDamaged.addCondition(data -> ItemHelper.hasInMainHand((LivingEntity)data.attacker, (Class[])new Class[]{WitherSwordItem.class})).addCondition(data -> data.source.m_7640_() == data.attacker).addConfig((UserConfig)WITHER);
            this.addContext((Context)onDamaged);
        }

        private void applyWither(OnDamagedData data) {
            EffectHelper.applyEffectIfPossible((LivingEntity)data.target, (MobEffect)MobEffects.f_19615_, (int)WITHER.getDuration(), (int)WITHER.getAmplifier());
        }
    }
}

