/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.models;

import com.majruszsdifficulty.entities.TankEntity;
import com.mlib.animations.Animation;
import com.mlib.animations.Frame;
import com.mlib.math.VectorHelper;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TankModel<Type extends TankEntity>
extends HierarchicalModel<Type> {
    static final Animation.Degrees SPECIAL_ATTACK_BODY_X = new Animation.Degrees(TankEntity.SPECIAL_ATTACK_DURATION);
    static final Animation.Degrees SPECIAL_ATTACK_ARMS_X = new Animation.Degrees(TankEntity.SPECIAL_ATTACK_DURATION);
    static final Animation.Degrees NORMAL_ATTACK_BODY_Y = new Animation.Degrees(TankEntity.NORMAL_ATTACK_DURATION);
    static final Animation.Vector NORMAL_ATTACK_ARM = new Animation.Vector(TankEntity.NORMAL_ATTACK_DURATION);
    public ModelPart root;
    public ModelPart body;
    public ModelPart head;
    public ModelPart arms;
    public ModelPart leftArm;
    public ModelPart leftForearm;
    public ModelPart rightArm;
    public ModelPart rightForearm;
    public ModelPart leftLeg;
    public ModelPart rightLeg;
    protected float normalAttackDurationRatioLeft = 0.0f;
    protected float specialAttackDurationRatioLeft = 0.0f;
    protected boolean isLeftHandAttack = false;

    public TankModel(ModelPart modelPart) {
        this.root = modelPart;
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.arms = this.body.m_171324_("arms");
        this.leftArm = this.arms.m_171324_("leftArm");
        this.leftForearm = this.leftArm.m_171324_("leftForearm");
        this.rightArm = this.arms.m_171324_("rightArm");
        this.rightForearm = this.rightArm.m_171324_("rightForearm");
        this.leftLeg = this.root.m_171324_("leftLeg");
        this.rightLeg = this.root.m_171324_("rightLeg");
    }

    public void setupAnim(Type entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float limbFactor1 = limbSwing * 0.3333f;
        float limbFactor2 = 0.9f * limbSwingAmount;
        float bodyFactor = 0.2f * limbSwingAmount;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180) + 0.0873f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)limbFactor1) * limbFactor2;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbFactor1 + (float)Math.PI)) * limbFactor2;
        this.body.f_104205_ = Mth.m_14089_((float)limbFactor1) * bodyFactor;
        float handMultiplier = this.isLeftHandAttack ? -1.0f : 1.0f;
        this.body.f_104204_ = this.head.f_104204_ * 0.4f + handMultiplier * NORMAL_ATTACK_BODY_Y.apply(this.normalAttackDurationRatioLeft, ageInTicks).floatValue();
        if (this.isLeftHandAttack) {
            this.rotateArm(this.leftArm, ageInTicks, this.normalAttackDurationRatioLeft);
            this.rotateArm(this.rightArm, ageInTicks, 1.0f);
        } else {
            this.rotateArm(this.leftArm, ageInTicks, 1.0f);
            this.rotateArm(this.rightArm, ageInTicks, this.normalAttackDurationRatioLeft);
        }
        this.body.f_104203_ = SPECIAL_ATTACK_BODY_X.apply(this.specialAttackDurationRatioLeft, ageInTicks).floatValue();
        this.arms.f_104203_ = SPECIAL_ATTACK_ARMS_X.apply(this.specialAttackDurationRatioLeft, ageInTicks).floatValue();
    }

    public void prepareMobModel(Type tank, float p_102862_, float p_102863_, float packedLight) {
        this.normalAttackDurationRatioLeft = ((TankEntity)((Object)tank)).isAttacking(TankEntity.AttackType.NORMAL) ? ((TankEntity)((Object)tank)).calculateAttackDurationRatioLeft() : 1.0f;
        this.specialAttackDurationRatioLeft = ((TankEntity)((Object)tank)).isAttacking(TankEntity.AttackType.SPECIAL) ? ((TankEntity)((Object)tank)).calculateAttackDurationRatioLeft() : 1.0f;
        this.isLeftHandAttack = ((TankEntity)((Object)tank)).isLeftHandAttack;
        super.m_6839_(tank, p_102862_, p_102863_, packedLight);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-8.0f, -22.0f, -5.0f, 16.0f, 12.0f, 8.0f, cubeDeformation).m_171514_(36, 40).m_171488_(-1.0f, -23.0f, 1.0f, 2.0f, 22.0f, 2.0f, cubeDeformation.m_171469_(-0.1f)).m_171514_(0, 40).m_171488_(-6.0f, -4.0f, -3.0f, 12.0f, 4.0f, 6.0f, cubeDeformation), PartPose.m_171423_((float)0.0f, (float)12.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        partDefinition.m_171597_("body").m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, cubeDeformation), PartPose.m_171423_((float)0.0f, (float)-22.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        partDefinition.m_171597_("body").m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-22.0f, (float)0.0f));
        partDefinition.m_171597_("body").m_171597_("arms").m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 16.0f, 5.0f, cubeDeformation), PartPose.m_171423_((float)-9.5f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.1745f));
        partDefinition.m_171597_("body").m_171597_("arms").m_171597_("rightArm").m_171599_("rightForearm", CubeListBuilder.m_171558_().m_171514_(44, 37).m_171488_(-2.5f, -0.5f, -2.5f, 5.0f, 16.0f, 5.0f, cubeDeformation.m_171469_(-0.2f)), PartPose.m_171423_((float)0.0f, (float)14.5f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        partDefinition.m_171597_("body").m_171597_("arms").m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 16.0f, 5.0f, cubeDeformation), PartPose.m_171423_((float)9.5f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        partDefinition.m_171597_("body").m_171597_("arms").m_171597_("leftArm").m_171599_("leftForearm", CubeListBuilder.m_171558_().m_171514_(44, 37).m_171488_(-2.5f, -2.0f, -3.5f, 5.0f, 16.0f, 5.0f, cubeDeformation.m_171469_(-0.2f)), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        partDefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)3.0f, (float)12.0f, (float)0.0f));
        partDefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, cubeDeformation), PartPose.m_171419_((float)-3.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    private void rotateArm(ModelPart arm, float ageInTicks, float duration) {
        float multiplier = arm == this.leftArm ? -1.0f : 1.0f;
        Vector3f vectorHandMultiplier = new Vector3f(1.0f, multiplier, multiplier);
        Animation.applyRotationInDegrees((Vector3f)VectorHelper.multiply((Vector3f)((Vector3f)NORMAL_ATTACK_ARM.apply(duration, ageInTicks)), (Vector3f)vectorHandMultiplier), (ModelPart)arm);
    }

    static {
        SPECIAL_ATTACK_BODY_X.addNewFloatFrame(0.0f, 10.0f).addNewFloatFrame(0.3f, -30.0f, Frame.InterpolationType.SQUARE).addNewFloatFrame(0.4f, -30.0f).addNewFloatFrame(0.6f, 45.0f, Frame.InterpolationType.SQUARE).addNewFloatFrame(0.7f, 35.0f).addNewFloatFrame(0.85f, 0.0f, Frame.InterpolationType.SQUARE).addNewFloatFrame(1.0f, 10.0f);
        SPECIAL_ATTACK_ARMS_X.addNewFloatFrame(0.0f, 0.0f).addNewFloatFrame(0.4f, -160.0f, Frame.InterpolationType.SQUARE).addNewFloatFrame(0.6f, -40.0f, Frame.InterpolationType.SQUARE).addNewFloatFrame(0.7f, -30.0f).addNewFloatFrame(0.85f, 10.0f, Frame.InterpolationType.SQUARE).addNewFloatFrame(1.0f, 0.0f, Frame.InterpolationType.SQUARE);
        NORMAL_ATTACK_BODY_Y.addNewFloatFrame(0.0f, 0.0f).addNewFloatFrame(0.15f, 30.0f, Frame.InterpolationType.SQUARE).addNewFloatFrame(0.25f, 30.0f).addNewFloatFrame(0.45f, -60.0f, Frame.InterpolationType.SQUARE).addNewFloatFrame(0.55f, -50.0f).addNewFloatFrame(1.0f, 0.0f, Frame.InterpolationType.SQUARE);
        NORMAL_ATTACK_ARM.addNewVectorFrame(0.0f, new Vector3f(0.0f, 0.0f, 10.0f)).addNewVectorFrame(0.2f, new Vector3f(45.0f, 0.0f, 45.0f), Frame.InterpolationType.SQUARE).addNewVectorFrame(0.3f, new Vector3f(45.0f, 0.0f, 45.0f)).addNewVectorFrame(0.5f, new Vector3f(-90.0f, -30.0f, 60.0f), Frame.InterpolationType.SQUARE).addNewVectorFrame(0.6f, new Vector3f(-80.0f, -25.0f, 50.0f), Frame.InterpolationType.SQUARE).addNewVectorFrame(1.0f, new Vector3f(0.0f, 0.0f, 10.0f), Frame.InterpolationType.SQUARE);
    }
}

