/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.treasurebags;

import com.majruszsdifficulty.PacketHandler;
import com.majruszsdifficulty.gamemodifiers.GameModifier;
import com.majruszsdifficulty.items.TreasureBagItem;
import com.majruszsdifficulty.treasurebags.LootData;
import com.majruszsdifficulty.treasurebags.LootProgressClient;
import com.mlib.ObfuscationGetter;
import com.mlib.Utility;
import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.contexts.OnPlayerLoggedContext;
import com.mlib.gamemodifiers.data.OnPlayerLoggedData;
import com.mlib.network.message.EntityMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class LootProgressManager
extends GameModifier {
    static final ObfuscationGetter.Field<LootTable, List<LootPool>> POOLS = new ObfuscationGetter.Field(LootTable.class, "f_79109_");
    static final ObfuscationGetter.Field<LootPool, LootPoolEntryContainer[]> ENTRIES = new ObfuscationGetter.Field(LootPool.class, "f_79023_");

    public static void updateProgress(TreasureBagItem treasureBagItem, Player player, List<ItemStack> generatedLoot) {
        String bagID = Utility.getRegistryString((Item)treasureBagItem);
        if (bagID == null) {
            return;
        }
        for (ItemStack itemStack : generatedLoot) {
            CompoundTag treasureBagTag;
            CompoundTag compoundTag;
            String itemID = Utility.getRegistryString((Item)itemStack.m_41720_());
            if (itemID == null || !(compoundTag = player.getPersistentData()).m_128441_(bagID) || !(treasureBagTag = compoundTag.m_128469_(bagID)).m_128441_(itemID)) continue;
            LootData lootData = LootData.read(treasureBagTag, itemID);
            lootData.unlock();
            lootData.write(treasureBagTag);
            compoundTag.m_128365_(bagID, (Tag)treasureBagTag);
        }
        LootProgressManager.notifyPlayerAboutChanges(player, treasureBagItem);
    }

    public static void cleanProgress(Player player) {
        for (TreasureBagItem treasureBagItem : TreasureBagItem.TREASURE_BAGS) {
            String bagID = Utility.getRegistryString((Item)treasureBagItem);
            if (bagID == null) continue;
            CompoundTag compoundTag = player.getPersistentData();
            if (compoundTag.m_128441_(bagID)) {
                compoundTag.m_128473_(bagID);
            }
            LootProgressManager.createDefaultProgress(player, treasureBagItem);
        }
        LootProgressManager.notifyPlayerAboutChanges(player);
    }

    public LootProgressManager() {
        super(GameModifier.TREASURE_BAG, "LootProgressManager", "");
        this.addContext((Context)new OnPlayerLoggedContext(this::onLogged));
    }

    private void onLogged(OnPlayerLoggedData data) {
        TreasureBagItem.TREASURE_BAGS.forEach(item -> LootProgressManager.createDefaultProgress(data.player, item));
        LootProgressManager.notifyPlayerAboutChanges(data.player);
    }

    private static void createDefaultProgress(Player player, TreasureBagItem treasureBagItem) {
        String bagID = Utility.getRegistryString((Item)treasureBagItem);
        List pools = (List)POOLS.get((Object)treasureBagItem.getLootTable());
        if (bagID == null || pools == null) {
            return;
        }
        LootContext context = TreasureBagItem.generateLootContext(player);
        for (LootPool lootPool : pools) {
            LootPoolEntryContainer[] entries = (LootPoolEntryContainer[])ENTRIES.get((Object)lootPool);
            if (entries == null) {
                return;
            }
            for (LootPoolEntryContainer entryContainer : entries) {
                LootItem lootItem = (LootItem)Utility.castIfPossible(LootItem.class, (Object)entryContainer);
                if (lootItem == null) continue;
                lootItem.m_6948_(itemStack -> {
                    CompoundTag compoundTag;
                    CompoundTag treasureBagTag;
                    String itemID = Utility.getRegistryString((Item)itemStack.m_41720_());
                    if (itemID == null) {
                        return;
                    }
                    if (itemID.equals("minecraft:book")) {
                        itemID = "minecraft:enchanted_book";
                    }
                    CompoundTag compoundTag2 = treasureBagTag = (compoundTag = player.getPersistentData()).m_128441_(bagID) ? compoundTag.m_128469_(bagID) : new CompoundTag();
                    if (!treasureBagTag.m_128441_(itemID)) {
                        LootData lootData = new LootData(itemID, false, lootItem.f_79676_);
                        lootData.write(treasureBagTag);
                    }
                    compoundTag.m_128365_(bagID, (Tag)treasureBagTag);
                }, context);
            }
        }
    }

    private static void notifyPlayerAboutChanges(Player player, TreasureBagItem treasureBagItem) {
        ServerPlayer serverPlayer = (ServerPlayer)Utility.castIfPossible(ServerPlayer.class, (Object)player);
        if (serverPlayer == null) {
            return;
        }
        String bagID = Utility.getRegistryString((Item)treasureBagItem);
        if (bagID == null) {
            return;
        }
        ArrayList<LootData> lootDataList = new ArrayList<LootData>();
        CompoundTag compoundTag = player.getPersistentData();
        if (!compoundTag.m_128441_(bagID)) {
            return;
        }
        CompoundTag treasureBagTag = compoundTag.m_128469_(bagID);
        for (String itemID : treasureBagTag.m_128431_()) {
            lootDataList.add(LootData.read(treasureBagTag, itemID));
        }
        lootDataList.sort(Comparator.comparingInt(a -> -a.quality));
        PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ProgressMessage((Entity)serverPlayer, bagID, lootDataList));
    }

    private static void notifyPlayerAboutChanges(Player player) {
        for (TreasureBagItem treasureBagItem : TreasureBagItem.TREASURE_BAGS) {
            LootProgressManager.notifyPlayerAboutChanges(player, treasureBagItem);
        }
    }

    public static class ProgressMessage
    extends EntityMessage {
        private final String treasureBagID;
        private final List<LootData> lootDataList;

        public ProgressMessage(Entity entity, String treasureBagID, List<LootData> lootDataList) {
            super(entity);
            this.treasureBagID = treasureBagID;
            this.lootDataList = lootDataList;
        }

        public ProgressMessage(FriendlyByteBuf buffer) {
            super(buffer);
            this.treasureBagID = buffer.m_130277_();
            this.lootDataList = buffer.m_236845_(byteBuffer -> new LootData(byteBuffer.m_130277_(), byteBuffer.readBoolean(), byteBuffer.readInt()));
        }

        public void encode(FriendlyByteBuf buffer) {
            super.encode(buffer);
            buffer.m_130070_(this.treasureBagID);
            buffer.m_236828_(this.lootDataList, (byteBuffer, lootData) -> {
                byteBuffer.m_130070_(lootData.itemID);
                byteBuffer.writeBoolean(lootData.isUnlocked);
                byteBuffer.writeInt(lootData.quality);
            });
        }

        @OnlyIn(value=Dist.CLIENT)
        public void receiveMessage(NetworkEvent.Context context) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                LootProgressClient.generateComponents(this.treasureBagID, this.lootDataList);
            }
        }
    }
}

