/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.treasurebags;

import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.gamemodifiers.GameModifier;
import com.majruszsdifficulty.items.TreasureBagItem;
import com.mlib.Utility;
import com.mlib.config.UserConfig;
import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.contexts.OnDamagedContext;
import com.mlib.gamemodifiers.contexts.OnDeathContext;
import com.mlib.gamemodifiers.contexts.OnItemFishedContext;
import com.mlib.gamemodifiers.contexts.OnPlayerTickContext;
import com.mlib.gamemodifiers.data.OnDamagedData;
import com.mlib.gamemodifiers.data.OnDeathData;
import com.mlib.gamemodifiers.data.OnItemFishedData;
import com.mlib.gamemodifiers.data.OnPlayerTickData;
import com.mlib.items.ItemHelper;
import com.mlib.nbt.NBTHelper;
import com.mlib.time.TimeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TreasureBagManager
extends GameModifier {
    static final String PARTICIPANT_LIST_TAG = "TreasureBagPlayersToReward";
    static final String PLAYER_TAG = "TreasureBagPlayerUUID";
    static final String FISHING_TAG = "TreasureBagFishingCounter";
    static final String RAID_TAG = "TreasureBagLastPillagerRaidID";
    static final List<Register> REGISTERS = new ArrayList<Register>();

    public static void addTreasureBagTo(EntityType<?> entityType, TreasureBagItem treasureBag) {
        REGISTERS.add(new Register(entityType, treasureBag));
    }

    @Nullable
    public static TreasureBagItem getTreasureBag(EntityType<?> entityType) {
        Register register = TreasureBagManager.getRegisterFor(entityType);
        return register != null ? register.treasureBag : null;
    }

    public static boolean hasTreasureBag(EntityType<?> entityType) {
        return TreasureBagManager.getRegisterFor(entityType) != null;
    }

    @Nullable
    private static Player getPlayerByUUID(ServerLevel level, CompoundTag tag) {
        return level.m_46003_(UUID.fromString(tag.m_128461_(PLAYER_TAG)));
    }

    @Nullable
    private static Register getRegisterFor(EntityType<?> entityType) {
        for (Register register : REGISTERS) {
            if (!register.entityType.equals(entityType)) continue;
            return register;
        }
        return null;
    }

    public TreasureBagManager() {
        super(GameModifier.TREASURE_BAG, "TreasureBagManager", "");
        OnDamagedContext onDamaged = new OnDamagedContext(this::addPlayerToParticipantList);
        onDamaged.addCondition(data -> data.attacker instanceof Player).addCondition(data -> TreasureBagManager.hasTreasureBag(data.target.m_6095_()));
        OnDeathContext onDeath = new OnDeathContext(this::rewardAllParticipants);
        onDeath.addCondition(data -> TreasureBagManager.hasTreasureBag(data.target.m_6095_())).addCondition(data -> {
            TreasureBagItem treasureBag = TreasureBagManager.getTreasureBag(data.target.m_6095_());
            return treasureBag != null && treasureBag.isEnabled();
        });
        OnItemFishedContext onFished = new OnItemFishedContext(this::giveTreasureBagToAngler);
        onFished.addCondition(data -> data.level != null).addCondition(data -> {
            int requiredFishCount = TreasureBagItem.Fishing.REQUIRED_FISH_COUNT.getCurrentGameStageValue();
            NBTHelper.IntegerData fishedItems = new NBTHelper.IntegerData((LivingEntity)data.player, FISHING_TAG);
            fishedItems.set(x -> (x + 1) % requiredFishCount);
            return fishedItems.get() == 0;
        }).addCondition(data -> TreasureBagItem.Fishing.CONFIG.isEnabled());
        OnPlayerTickContext onTick = new OnPlayerTickContext(this::giveTreasureBagToHero);
        onTick.addCondition(data -> data.level != null).addCondition(data -> TimeHelper.hasServerTicksPassed((int)20)).addCondition(data -> {
            assert (data.level != null);
            Raid raid = data.level.m_8832_(data.player.m_20183_());
            if (raid == null || !raid.m_37767_() || !data.player.m_21023_(MobEffects.f_19595_)) {
                return false;
            }
            NBTHelper.IntegerData lastRaidId = new NBTHelper.IntegerData((LivingEntity)data.player, RAID_TAG);
            if (lastRaidId.get().intValue() == raid.m_37781_()) {
                return false;
            }
            lastRaidId.set(Integer.valueOf(raid.m_37781_()));
            return true;
        });
        this.addContexts(new Context[]{onDamaged, onDeath, onFished, onTick});
        this.addConfigs((UserConfig[])TreasureBagItem.getConfigs());
    }

    private void addPlayerToParticipantList(OnDamagedData damagedData) {
        Player player = (Player)damagedData.attacker;
        ListTag listNBT = TreasureBagManager.getOrCreateList(damagedData.target);
        CompoundTag playerNBT = TreasureBagManager.createPlayerTag(player);
        if (!TreasureBagManager.isPlayerInList(player, listNBT)) {
            listNBT.add((Object)playerNBT);
            damagedData.target.getPersistentData().m_128365_(PARTICIPANT_LIST_TAG, (Tag)listNBT);
        }
    }

    private static ListTag getOrCreateList(LivingEntity entity) {
        CompoundTag data = entity.getPersistentData();
        return data.m_128441_(PARTICIPANT_LIST_TAG) ? data.m_128437_(PARTICIPANT_LIST_TAG, 10) : new ListTag();
    }

    private static CompoundTag createPlayerTag(Player player) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(PLAYER_TAG, Utility.getPlayerUUID((Player)player));
        return nbt;
    }

    private static boolean isPlayerInList(Player player, ListTag listNBT) {
        String uuid = Utility.getPlayerUUID((Player)player);
        for (int i = 0; i < listNBT.size(); ++i) {
            if (!listNBT.m_128728_(i).m_128461_(PLAYER_TAG).equals(uuid)) continue;
            return true;
        }
        return false;
    }

    private void rewardAllParticipants(OnDeathData deathData) {
        LivingEntity killedEntity = deathData.target;
        ListTag listNBT = TreasureBagManager.getOrCreateList(killedEntity);
        if (deathData.level == null) {
            return;
        }
        for (int i = 0; i < listNBT.size(); ++i) {
            TreasureBagManager.giveTreasureBagTo(TreasureBagManager.getPlayerByUUID(deathData.level, listNBT.m_128728_(i)), TreasureBagManager.getTreasureBag(killedEntity.m_6095_()), deathData.level);
        }
        listNBT.clear();
    }

    private static void giveTreasureBagTo(Player player, TreasureBagItem item, ServerLevel level) {
        if (player == null || level == null) {
            return;
        }
        ItemHelper.giveItemStackToPlayer((ItemStack)new ItemStack((ItemLike)item), (Player)player, (ServerLevel)level);
    }

    private void giveTreasureBagToAngler(OnItemFishedData fishedData) {
        TreasureBagManager.giveTreasureBagTo(fishedData.player, (TreasureBagItem)((Object)Registries.FISHING_TREASURE_BAG.get()), fishedData.level);
    }

    private void giveTreasureBagToHero(OnPlayerTickData tickData) {
        TreasureBagManager.giveTreasureBagTo(tickData.player, (TreasureBagItem)((Object)Registries.PILLAGER_TREASURE_BAG.get()), tickData.level);
    }

    record Register(EntityType<?> entityType, TreasureBagItem treasureBag) {
    }
}

