/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.animations;

import com.mlib.animations.Frame;
import com.mlib.animations.FrameFloat;
import com.mlib.animations.FrameVector;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.geom.ModelPart;

public class Animation<Type> {
    final List<Frame<Type>> frames = new ArrayList<Frame<Type>>();
    final float step;

    public Animation(int ticks) {
        this.step = 1.0f / (float)ticks;
    }

    public static void applyRotationInDegrees(Vector3f value, ModelPart modelPart) {
        value.m_122261_((float)Math.PI / 180);
        modelPart.m_171327_(value.m_122239_(), value.m_122260_(), value.m_122269_());
    }

    public static void applyPosition(Vector3f value, ModelPart modelPart) {
        modelPart.m_104227_(value.m_122239_(), value.m_122260_(), value.m_122269_());
    }

    public Animation<Type> addFrame(Frame<Type> frame) {
        this.frames.add(frame);
        return this;
    }

    public Type apply(float duration, float ageInTicks) {
        Frame<Type> currentFrame = null;
        Frame<Type> nextFrame = null;
        for (int i = 0; i < this.frames.size(); ++i) {
            Frame<Type> frame = this.frames.get(i);
            if (duration > frame.startDuration) continue;
            currentFrame = this.frames.get(Math.max(i - 1, 0));
            nextFrame = frame;
            break;
        }
        if (currentFrame == null) {
            return this.frames.get(this.frames.size() - 1).getValue();
        }
        return this.interpolate(duration + ageInTicks % 1.0f * this.step, currentFrame, nextFrame);
    }

    private Type interpolate(float duration, Frame<Type> currentFrame, Frame<Type> nextFrame) {
        float ratio = (duration - currentFrame.startDuration) / (nextFrame.startDuration - currentFrame.startDuration);
        ratio = nextFrame.interpolationType.apply(Math.min(ratio, 1.0f));
        return currentFrame.interpolate(ratio, nextFrame);
    }

    public static class Vector
    extends Animation<Vector3f> {
        public Vector(int ticks) {
            super(ticks);
        }

        public Vector addFrame(FrameVector frame) {
            this.frames.add(frame);
            return this;
        }

        public Vector addNewVectorFrame(float startDuration, Vector3f value, Frame.InterpolationType interpolationType) {
            return this.addFrame(new FrameVector(startDuration, value, interpolationType));
        }

        public Vector addNewVectorFrame(float startDuration, Vector3f value) {
            return this.addFrame(new FrameVector(startDuration, value));
        }
    }

    public static class Degrees
    extends Float {
        public Degrees(int ticks) {
            super(ticks);
        }

        @Override
        public java.lang.Float apply(float duration, float ageInTicks) {
            return java.lang.Float.valueOf((float)Math.PI / 180 * ((java.lang.Float)super.apply(duration, ageInTicks)).floatValue());
        }
    }

    public static class Float
    extends Animation<java.lang.Float> {
        public Float(int ticks) {
            super(ticks);
        }

        public Float addFrame(FrameFloat frame) {
            this.frames.add(frame);
            return this;
        }

        public Float addNewFloatFrame(float startDuration, float value, Frame.InterpolationType interpolationType) {
            return this.addFrame(new FrameFloat(startDuration, value, interpolationType));
        }

        public Float addNewFloatFrame(float startDuration, float value) {
            return this.addFrame(new FrameFloat(startDuration, value));
        }
    }
}

