/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.entities;

import com.mlib.Utility;
import com.mlib.math.AABBHelper;
import com.mlib.math.VectorHelper;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityHelper {
    public static void cheatDeath(LivingEntity entity, float healthRatio, boolean shouldPlayEffects) {
        Level level;
        entity.m_21153_(entity.m_21233_() * healthRatio);
        if (shouldPlayEffects && (level = entity.f_19853_) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123767_, entity.m_20185_(), entity.m_20227_(0.75), entity.m_20189_(), 64, 0.25, 0.5, 0.25, 0.5);
            level2.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12513_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    @Deprecated
    @Nullable
    public static Player getPlayerFromEntity(@Nullable Entity entity) {
        return Utility.castIfPossible(Player.class, entity);
    }

    public static boolean isOnCreativeMode(Player player) {
        return player.m_150110_().f_35937_;
    }

    public static boolean isAnimal(@Nullable Entity entity) {
        return entity instanceof Animal;
    }

    public static boolean isHuman(Entity entity) {
        return entity instanceof Villager || entity instanceof WanderingTrader || entity instanceof Player || entity instanceof Witch || entity instanceof Pillager;
    }

    public static double getHealthRatio(LivingEntity entity) {
        return Mth.m_14008_((double)(entity.m_21223_() / entity.m_21233_()), (double)0.0, (double)1.0);
    }

    public static double getMissingHealthRatio(LivingEntity entity) {
        return 1.0 - EntityHelper.getHealthRatio(entity);
    }

    public static void disableCurrentItem(Player player, double seconds) {
        player.m_36335_().m_41524_(player.m_21211_().m_41720_(), Utility.secondsToTicks(seconds));
        player.m_5810_();
        player.f_19853_.m_7605_((Entity)player, (byte)30);
    }

    public static <EntityType extends Entity> List<EntityType> getEntitiesInBox(Class<EntityType> entityClass, ServerLevel level, Vec3 position, double sideLength, Predicate<EntityType> extraPredicate) {
        AABB axisAligned = AABBHelper.createInflatedAABB(position, sideLength / 2.0);
        return level.m_6443_(entityClass, axisAligned, extraPredicate);
    }

    public static <EntityType extends Entity> List<EntityType> getEntitiesInBox(Class<EntityType> entityClass, ServerLevel level, BlockPos blockPosition, double sideLength, Predicate<EntityType> extraPredicate) {
        return EntityHelper.getEntitiesInBox(entityClass, level, VectorHelper.convertToVec3(blockPosition), sideLength, extraPredicate);
    }

    public static <EntityType extends Entity> List<EntityType> getEntitiesInBox(Class<EntityType> entityClass, ServerLevel level, Entity entity, double sideLength, Predicate<EntityType> extraPredicate) {
        return EntityHelper.getEntitiesInBox(entityClass, level, entity.m_20182_(), sideLength, extraPredicate);
    }

    public static <EntityType extends Entity> List<EntityType> getEntitiesInSphere(Class<EntityType> entityClass, ServerLevel level, Vec3 position, double radius, Predicate<EntityType> extraPredicate) {
        Predicate<Entity> distancePredicate = entity -> VectorHelper.distance(position, entity.m_20182_()) <= radius;
        return EntityHelper.getEntitiesInBox(entityClass, level, position, radius * 2.0, distancePredicate.and(extraPredicate));
    }

    public static <EntityType extends Entity> List<EntityType> getEntitiesInSphere(Class<EntityType> entityClass, ServerLevel level, BlockPos blockPosition, double radius, Predicate<EntityType> extraPredicate) {
        return EntityHelper.getEntitiesInSphere(entityClass, level, VectorHelper.convertToVec3(blockPosition), radius, extraPredicate);
    }

    public static <EntityType extends Entity> List<EntityType> getEntitiesInSphere(Class<EntityType> entityClass, ServerLevel level, Entity entity, double radius, Predicate<EntityType> extraPredicate) {
        return EntityHelper.getEntitiesInSphere(entityClass, level, entity.m_20182_(), radius, extraPredicate);
    }
}

