/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.features;

import com.mlib.Random;
import com.mlib.effects.ParticleHandler;
import com.mlib.events.AnyLootModificationEvent;
import com.mlib.events.BlockSmeltCheckEvent;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnLootContext;
import com.mlib.gamemodifiers.data.OnLootData;
import com.mlib.gamemodifiers.parameters.ContextParameters;
import com.mlib.gamemodifiers.parameters.Priority;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockSmelter
extends GameModifier {
    public BlockSmelter() {
        super("BlockSmelter", "");
        OnLootContext onLoot = new OnLootContext(this::replaceWithSmeltedLoot, new ContextParameters(Priority.HIGH, "", ""));
        onLoot.addCondition(data -> data.blockState != null).addCondition(data -> data.level != null).addCondition(data -> {
            Player player;
            Entity patt1478$temp = data.entity;
            return patt1478$temp instanceof Player && !(player = (Player)patt1478$temp).m_6047_();
        }).addCondition(this::checkEventListeners);
        this.addContext(onLoot);
    }

    private boolean checkEventListeners(OnLootData data) {
        BlockSmeltCheckEvent event = new BlockSmeltCheckEvent((AnyLootModificationEvent)data.event);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.shouldSmelt;
    }

    private void replaceWithSmeltedLoot(OnLootData data) {
        List<ItemStack> generatedLoot = data.generatedLoot;
        ServerLevel level = data.level;
        Vec3 position = data.origin;
        RecipeManager recipeManager = level.m_7465_();
        int amountOfSmeltedItems = 0;
        ObjectArrayList smeltedLoot = new ObjectArrayList();
        for (ItemStack itemStack : generatedLoot) {
            smeltedLoot.add((Object)this.getSmeltedItemStack(itemStack, level));
            Optional recipe = recipeManager.m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), (Level)level);
            if (recipe.isEmpty()) continue;
            int experience = Random.roundRandomly(((SmeltingRecipe)recipe.get()).m_43750_() * (float)itemStack.m_41613_());
            if (experience > 0) {
                level.m_7967_((Entity)new ExperienceOrb((Level)level, position.f_82479_, position.f_82480_, position.f_82481_, experience));
            }
            amountOfSmeltedItems += itemStack.m_41613_();
        }
        if (amountOfSmeltedItems > 0) {
            ParticleHandler.SMELT.spawn(level, position, amountOfSmeltedItems + Random.nextInt(4, 7));
        }
        generatedLoot.clear();
        generatedLoot.addAll((Collection<ItemStack>)smeltedLoot);
    }

    private ItemStack smeltIfPossible(ItemStack itemStack, ServerLevel level) {
        return level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), (Level)level).map(AbstractCookingRecipe::m_8043_).filter(i -> !i.m_41619_()).map(i -> ItemHandlerHelper.copyStackWithSize((ItemStack)i, (int)(itemStack.m_41613_() * i.m_41613_()))).orElse(itemStack);
    }

    private ItemStack getSmeltedItemStack(ItemStack itemStackToSmelt, ServerLevel level) {
        ItemStack smeltedItemStack = this.smeltIfPossible(itemStackToSmelt, level);
        if (smeltedItemStack.m_41613_() != itemStackToSmelt.m_41613_()) {
            smeltedItemStack.m_41764_(itemStackToSmelt.m_41613_());
        }
        return smeltedItemStack;
    }
}

