/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers.configs;

import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IntegerConfig;
import com.mlib.config.UserConfig;
import com.mlib.effects.EffectHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;

public class EffectConfig
extends ConfigGroup {
    static final int MIN_AMPLIFIER = 1;
    static final int MAX_AMPLIFIER = 10;
    static final double MIN_DURATION = 1.0;
    static final double MAX_DURATION = 999.0;
    static final double MIN_LIMIT = 5.0;
    static final double MAX_LIMIT = 999.0;
    final Supplier<MobEffect> effect;
    final IntegerConfig amplifier;
    final DoubleConfig duration;
    final Optional<DoubleConfig> maxDuration;

    public EffectConfig(String groupName, Supplier<MobEffect> effect, int amplifier, double duration, Optional<Double> maxDuration) {
        super(groupName, "", new UserConfig[0]);
        this.effect = effect;
        this.amplifier = new IntegerConfig("amplifier", "Level of the effect to apply.", false, amplifier + 1, 1, 10);
        this.duration = new DoubleConfig("duration", "Duration in seconds.", false, duration, 1.0, 999.0);
        this.maxDuration = maxDuration.map(value -> new DoubleConfig("maximum_duration", "Maximum duration in seconds it can reach.", false, (double)value, 5.0, 999.0));
        this.addConfigs(this.amplifier, this.duration);
        this.maxDuration.ifPresent(this::addConfig);
    }

    public EffectConfig(String groupName, Supplier<MobEffect> effect, int amplifier, double duration, double maxDuration) {
        this(groupName, effect, amplifier, duration, Optional.of(maxDuration));
    }

    public EffectConfig(String groupName, Supplier<MobEffect> effect, int amplifier, double duration) {
        this(groupName, effect, amplifier, duration, Optional.empty());
    }

    public void apply(LivingEntity entity, int extraAmplifier, int extraDuration) {
        if (this.maxDuration.isPresent()) {
            EffectHelper.stackEffectIfPossible(entity, this.getEffect(), this.getDuration() + extraDuration, this.getAmplifier() + extraAmplifier, this.getMaxDuration());
        } else {
            EffectHelper.applyEffectIfPossible(entity, this.getEffect(), this.getDuration() + extraDuration, this.getAmplifier() + extraAmplifier);
        }
    }

    public void apply(LivingEntity entity) {
        this.apply(entity, 0, 0);
    }

    public MobEffect getEffect() {
        return this.effect.get();
    }

    public int getAmplifier() {
        return (Integer)this.amplifier.get() - 1;
    }

    public int getDuration() {
        return this.duration.asTicks();
    }

    public int getMaxDuration() {
        assert (this.maxDuration.isPresent());
        return this.maxDuration.get().asTicks();
    }
}

