/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.loot_modifiers;

import com.google.common.base.Suppliers;
import com.mlib.events.HarvestCropEvent;
import com.mlib.loot_modifiers.LootHelper;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.eventbus.api.Event;

public class HarvestCrop
extends LootModifier {
    public static final Supplier<Codec<HarvestCrop>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> HarvestCrop.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, HarvestCrop::new)));

    public HarvestCrop(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState blockState = (BlockState)LootHelper.getParameter(context, LootContextParams.f_81461_);
        if (blockState == null || !(blockState.m_60734_() instanceof CropBlock)) {
            return generatedLoot;
        }
        CropBlock crops = (CropBlock)blockState.m_60734_();
        Entity entity = (Entity)LootHelper.getParameter(context, LootContextParams.f_81455_);
        ItemStack tool = (ItemStack)LootHelper.getParameter(context, LootContextParams.f_81463_);
        Vec3 origin = (Vec3)LootHelper.getParameter(context, LootContextParams.f_81460_);
        if (origin == null || !(entity instanceof Player)) {
            return generatedLoot;
        }
        MinecraftForge.EVENT_BUS.post((Event)new HarvestCropEvent((Player)entity, (List<ItemStack>)generatedLoot, crops, blockState, tool, origin));
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

