/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.features;

import com.mlib.levels.LevelHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FarmlandTiller {
    public static final List<Register> registerList = new ArrayList<Register>();

    public static void addRegister(Register register) {
        registerList.add(register);
    }

    @SubscribeEvent
    public static void onHoeUse(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        ServerLevel level = LevelHelper.getServerLevelFromEntity((Entity)player);
        BlockPos blockPosition = event.getPos();
        ItemStack itemStack = event.getItemStack();
        InteractionHand hand = event.getHand();
        Direction direction = event.getFace();
        if (level == null || event.getFace() == null || player.m_6144_()) {
            return;
        }
        Data targetData = FarmlandTiller.getData(level, player, blockPosition, hand, direction, 0, 0);
        if (targetData == null || !targetData.predicate.test(targetData.context)) {
            return;
        }
        int area = FarmlandTiller.getArea(level, player, itemStack);
        if (area == 0) {
            return;
        }
        for (int x = -area; x <= area; ++x) {
            for (int z = -area; z <= area; ++z) {
                Data offsetData = FarmlandTiller.getData(level, player, blockPosition, hand, direction, x, z);
                if (offsetData == null || !offsetData.predicate.test(offsetData.context)) continue;
                offsetData.consumer.accept(offsetData.context);
                itemStack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(hand));
            }
        }
    }

    protected static int getArea(ServerLevel level, Player player, ItemStack itemStack) {
        int areaSum = 0;
        int areaMax = 0;
        for (Register register : registerList) {
            if (!register.shouldBeExecuted(level, player, itemStack)) continue;
            int area = register.getArea(level, player, itemStack);
            areaMax = Math.max(areaMax, area);
            if (!register.isSummable(level, player, itemStack)) continue;
            areaSum += area;
        }
        return Math.max(areaSum, areaMax);
    }

    @Nullable
    protected static Data getData(ServerLevel level, Player player, BlockPos blockPosition, InteractionHand hand, Direction direction, int x, int z) {
        BlockPos offsetPosition = blockPosition.m_7918_(x, 0, z);
        BlockState blockState = level.m_8055_(offsetPosition);
        Pair pair = (Pair)HoeItem.f_41332_.get(blockState.m_60734_());
        BlockHitResult hitResult = new BlockHitResult(player.m_20182_(), direction, offsetPosition, true);
        UseOnContext context = new UseOnContext(player, hand, hitResult);
        return pair != null ? new Data((Predicate)pair.getFirst(), (Consumer)pair.getSecond(), context) : null;
    }

    private static class Data {
        public Predicate<UseOnContext> predicate;
        public Consumer<UseOnContext> consumer;
        public UseOnContext context;

        public Data(Predicate<UseOnContext> predicate, Consumer<UseOnContext> consumer, UseOnContext context) {
            this.predicate = predicate;
            this.consumer = consumer;
            this.context = context;
        }
    }

    @FunctionalInterface
    public static interface Register {
        public boolean shouldBeExecuted(ServerLevel var1, Player var2, ItemStack var3);

        default public int getArea(ServerLevel level, Player player, ItemStack itemStack) {
            return 1;
        }

        default public boolean isSummable(ServerLevel level, Player player, ItemStack itemStack) {
            return true;
        }
    }
}

