/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.gamemodifiers.contexts;

import com.mlib.Utility;
import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.data.OnPlayerInteractData;
import com.mlib.gamemodifiers.parameters.ContextParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class OnPlayerInteractContext
extends Context<OnPlayerInteractData> {
    static final List<OnPlayerInteractContext> CONTEXTS = new ArrayList<OnPlayerInteractContext>();

    public OnPlayerInteractContext(Consumer<OnPlayerInteractData> consumer, ContextParameters params) {
        super(OnPlayerInteractData.class, consumer, params);
        Context.addSorted(CONTEXTS, this);
    }

    public OnPlayerInteractContext(Consumer<OnPlayerInteractData> consumer) {
        this(consumer, new ContextParameters());
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Context.accept(CONTEXTS, new OnPlayerInteractData((PlayerInteractEvent)event, Utility.castIfPossible(LivingEntity.class, event.getTarget())));
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Context.accept(CONTEXTS, new OnPlayerInteractData((PlayerInteractEvent)event, (LivingEntity)event.getEntity()));
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Context.accept(CONTEXTS, new OnPlayerInteractData((PlayerInteractEvent)event, (LivingEntity)event.getEntity()));
    }
}

