/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.items;

import com.mlib.MajruszLibrary;
import com.mlib.Random;
import com.mlib.entities.EntityHelper;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemHelper {
    private static final double MINECRAFT_WEAPON_ENCHANT_CHANCE = 0.25;
    private static final double MINECRAFT_ARMOR_PIECE_ENCHANT_CHANCE = 0.5;

    public static int getEnchantmentLevel(double clampedRegionalDifficulty) {
        return (int)(5.0 + 18.0 * clampedRegionalDifficulty);
    }

    public static ItemStack damageItem(ItemStack itemStack, double factor) {
        if ((double)itemStack.m_41776_() * factor < 1.0) {
            return ItemStack.f_41583_;
        }
        itemStack.m_41721_(MajruszLibrary.RANDOM.m_188503_((int)((double)itemStack.m_41776_() * factor)));
        return itemStack;
    }

    public static ItemStack enchantItem(ItemStack itemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed) {
        int enchantmentLevel = ItemHelper.getEnchantmentLevel(clampedRegionalDifficulty);
        return EnchantmentHelper.m_220292_((RandomSource)MajruszLibrary.RANDOM, (ItemStack)itemStack, (int)enchantmentLevel, (boolean)isTreasureAllowed);
    }

    public static ItemStack tryEnchantItem(ItemStack itemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed, double chance) {
        return Random.tryChance(chance) ? ItemHelper.enchantItem(itemStack, clampedRegionalDifficulty, isTreasureAllowed) : itemStack;
    }

    public static ItemStack tryEnchantWeapon(ItemStack weaponItemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed) {
        return ItemHelper.tryEnchantItem(weaponItemStack, clampedRegionalDifficulty, isTreasureAllowed, 0.25);
    }

    public static ItemStack tryEnchantArmor(ItemStack armorItemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed) {
        return ItemHelper.tryEnchantItem(armorItemStack, clampedRegionalDifficulty, isTreasureAllowed, 0.5);
    }

    public static ItemStack damageAndEnchantItem(ItemStack itemStack, double clampedRegionalDifficulty, boolean isTreasureAllowed, double damageFactor) {
        return ItemHelper.damageItem(ItemHelper.enchantItem(itemStack, clampedRegionalDifficulty, isTreasureAllowed), damageFactor);
    }

    public static void addEnchantmentTypeToItemGroup(CreativeModeTab itemTab, EnchantmentCategory category) {
        EnchantmentCategory[] group = itemTab.m_40795_();
        if (group.length == 0) {
            itemTab.m_40781_(new EnchantmentCategory[]{category});
            return;
        }
        EnchantmentCategory[] temporary = new EnchantmentCategory[group.length + 1];
        System.arraycopy(group, 0, temporary, 0, group.length);
        temporary[group.length - 1] = category;
        itemTab.m_40781_(temporary);
    }

    public static void addEnchantmentTypesToItemGroup(CreativeModeTab itemTab, EnchantmentCategory ... categories) {
        EnchantmentCategory[] group = itemTab.m_40795_();
        if (group.length == 0) {
            itemTab.m_40781_(categories);
        } else {
            EnchantmentCategory[] temporary = new EnchantmentCategory[group.length + categories.length];
            System.arraycopy(group, 0, temporary, 0, group.length);
            int i = 1;
            EnchantmentCategory[] enchantmentCategoryArray = categories;
            int n = enchantmentCategoryArray.length;
            for (int j = 0; j < n; ++j) {
                EnchantmentCategory category;
                temporary[group.length - i] = category = enchantmentCategoryArray[j];
                ++i;
            }
            itemTab.m_40781_(temporary);
        }
    }

    public static void giveItemStackToPlayer(ItemStack itemStack, Player player, ServerLevel level) {
        if (!player.m_150109_().m_36054_(itemStack)) {
            double x = player.m_20185_();
            double y = player.m_20186_() + 1.0;
            double z = player.m_20189_();
            level.m_7967_((Entity)new ItemEntity((Level)level, x, y, z, itemStack));
        }
    }

    public static void consumeItemOnUse(ItemStack itemStack, Player player) {
        player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
        if (!EntityHelper.isOnCreativeMode(player)) {
            itemStack.m_41774_(1);
        }
    }

    @SafeVarargs
    public static boolean has(@Nullable LivingEntity entity, EquipmentSlot equipmentSlot, Class<? extends Item> ... itemClasses) {
        Item item = entity != null ? entity.m_6844_(equipmentSlot).m_41720_() : null;
        for (Class<? extends Item> itemClass : itemClasses) {
            if (!itemClass.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static boolean hasInMainHand(@Nullable LivingEntity entity, Class<? extends Item> ... itemClasses) {
        return ItemHelper.has(entity, EquipmentSlot.MAINHAND, itemClasses);
    }

    public static ItemStack getCurrentlyUsedItem(LivingEntity entity) {
        return entity.m_6117_() ? entity.m_21120_(entity.m_7655_()) : ItemStack.f_41583_;
    }

    public static ItemStack getMatchingHandItem(LivingEntity entity, Predicate<ItemStack> predicate) {
        return predicate.test(entity.m_21205_()) ? entity.m_21205_() : entity.m_21206_();
    }
}

