/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.math;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class VectorHelper {
    public static Vector3f add(Vector3f vector1, Vector3f vector2) {
        return new Vector3f(vector1.m_122239_() + vector2.m_122239_(), vector1.m_122260_() + vector2.m_122260_(), vector1.m_122269_() + vector2.m_122269_());
    }

    public static Vector3d add(Vector3d vector1, Vector3d vector2) {
        return new Vector3d(vector1.f_86214_ + vector2.f_86214_, vector1.f_86215_ + vector2.f_86215_, vector1.f_86216_ + vector2.f_86216_);
    }

    public static Vec3 add(Vec3 vector1, Vec3 vector2) {
        return new Vec3(vector1.f_82479_ + vector2.f_82479_, vector1.f_82480_ + vector2.f_82480_, vector1.f_82481_ + vector2.f_82481_);
    }

    public static <Type extends Number> Vec3 add(Vec3 vector, Type value) {
        return new Vec3(vector.f_82479_ + value.doubleValue(), vector.f_82480_ + value.doubleValue(), vector.f_82481_ + value.doubleValue());
    }

    public static Vector3f negate(Vector3f vector) {
        return new Vector3f(-vector.m_122239_(), -vector.m_122260_(), -vector.m_122269_());
    }

    public static Vector3d negate(Vector3d vector) {
        return new Vector3d(-vector.f_86214_, -vector.f_86215_, -vector.f_86216_);
    }

    public static Vec3 negate(Vec3 vector) {
        return new Vec3(-vector.f_82479_, -vector.f_82480_, -vector.f_82481_);
    }

    public static Vector3f subtract(Vector3f vector1, Vector3f vector2) {
        return VectorHelper.add(vector1, VectorHelper.negate(vector2));
    }

    public static Vector3d subtract(Vector3d vector1, Vector3d vector2) {
        return VectorHelper.add(vector1, VectorHelper.negate(vector2));
    }

    public static Vec3 subtract(Vec3 vector1, Vec3 vector2) {
        return VectorHelper.add(vector1, VectorHelper.negate(vector2));
    }

    public static <Type extends Number> Vec3 subtract(Vec3 vector, Type value) {
        return VectorHelper.add(vector, -value.doubleValue());
    }

    public static Vector3f multiply(Vector3f vector1, Vector3f vector2) {
        return new Vector3f(vector1.m_122239_() * vector2.m_122239_(), vector1.m_122260_() * vector2.m_122260_(), vector1.m_122269_() * vector2.m_122269_());
    }

    public static Vector3d multiply(Vector3d vector1, Vector3d vector2) {
        return new Vector3d(vector1.f_86214_ * vector2.f_86214_, vector1.f_86215_ * vector2.f_86215_, vector1.f_86216_ * vector2.f_86216_);
    }

    public static Vec3 multiply(Vec3 vector1, Vec3 vector2) {
        return new Vec3(vector1.f_82479_ * vector2.f_82479_, vector1.f_82480_ * vector2.f_82480_, vector1.f_82481_ * vector2.f_82481_);
    }

    public static <Type extends Number> Vec3 multiply(Vec3 vector, Type value) {
        return new Vec3(vector.f_82479_ * value.doubleValue(), vector.f_82480_ * value.doubleValue(), vector.f_82481_ * value.doubleValue());
    }

    public static Vector3f divide(Vector3f vector1, Vector3f vector2) {
        return new Vector3f(vector1.m_122239_() / vector2.m_122239_(), vector1.m_122260_() / vector2.m_122260_(), vector1.m_122269_() / vector2.m_122269_());
    }

    public static Vector3d divide(Vector3d vector1, Vector3d vector2) {
        return new Vector3d(vector1.f_86214_ / vector2.f_86214_, vector1.f_86215_ / vector2.f_86215_, vector1.f_86216_ / vector2.f_86216_);
    }

    public static Vec3 divide(Vec3 vector1, Vec3 vector2) {
        return new Vec3(vector1.f_82479_ / vector2.f_82479_, vector1.f_82480_ / vector2.f_82480_, vector1.f_82481_ / vector2.f_82481_);
    }

    public static <Type extends Number> Vec3 divide(Vec3 vector, Type value) {
        return new Vec3(vector.f_82479_ / value.doubleValue(), vector.f_82480_ / value.doubleValue(), vector.f_82481_ / value.doubleValue());
    }

    public static float dot(Vector3f vector1, Vector3f vector2) {
        return vector1.m_122276_(vector2);
    }

    public static float dot(Vector3f vector) {
        return VectorHelper.dot(vector, vector);
    }

    public static double dot(Vector3d vector1, Vector3d vector2) {
        return vector1.f_86214_ * vector2.f_86214_ + vector1.f_86215_ * vector2.f_86215_ + vector1.f_86216_ * vector2.f_86216_;
    }

    public static double dot(Vector3d vector) {
        return VectorHelper.dot(vector, vector);
    }

    public static double dot(Vec3 vector1, Vec3 vector2) {
        return vector1.m_82526_(vector2);
    }

    public static double dot(Vec3 vector) {
        return VectorHelper.dot(vector, vector);
    }

    public static float distanceSquared(Vector3f vector1, Vector3f vector2) {
        return VectorHelper.dot(VectorHelper.subtract(vector1, vector2));
    }

    public static float distance(Vector3f vector1, Vector3f vector2) {
        return (float)Math.sqrt(VectorHelper.distanceSquared(vector1, vector2));
    }

    public static float length(Vector3f vector) {
        return VectorHelper.distance(vector, Vector3f.f_176763_);
    }

    public static double distanceSquared(Vector3d vector1, Vector3d vector2) {
        return VectorHelper.dot(VectorHelper.subtract(vector1, vector2));
    }

    public static double distance(Vector3d vector1, Vector3d vector2) {
        return Math.sqrt(VectorHelper.distanceSquared(vector1, vector2));
    }

    public static double length(Vector3d vector) {
        return VectorHelper.distance(vector, new Vector3d(0.0, 0.0, 0.0));
    }

    public static double distanceSquared(Vec3 vector1, Vec3 vector2) {
        return VectorHelper.dot(VectorHelper.subtract(vector1, vector2));
    }

    public static double distance(Vec3 vector1, Vec3 vector2) {
        return Math.sqrt(VectorHelper.distanceSquared(vector1, vector2));
    }

    public static double length(Vec3 vector) {
        return VectorHelper.distance(vector, new Vec3(0.0, 0.0, 0.0));
    }

    public static Vector3f normalize(Vector3f vector) {
        float length = VectorHelper.length(vector);
        return (double)length < 1.0E-4 ? vector : VectorHelper.divide(vector, new Vector3f(length, length, length));
    }

    public static Vector3d normalize(Vector3d vector) {
        double length = VectorHelper.length(vector);
        return length < 1.0E-4 ? vector : VectorHelper.divide(vector, new Vector3d(length, length, length));
    }

    public static Vec3 normalize(Vec3 vector) {
        double length = VectorHelper.length(vector);
        return length < 1.0E-4 ? vector : VectorHelper.divide(vector, new Vec3(length, length, length));
    }

    public static Vector3f lerp(float ratio, Vector3f vector1, Vector3f vector2) {
        float x = Mth.m_14179_((float)ratio, (float)vector1.m_122239_(), (float)vector2.m_122239_());
        float y = Mth.m_14179_((float)ratio, (float)vector1.m_122260_(), (float)vector2.m_122260_());
        float z = Mth.m_14179_((float)ratio, (float)vector1.m_122269_(), (float)vector2.m_122269_());
        return new Vector3f(x, y, z);
    }

    public static Vector3d lerp(double ratio, Vector3d vector1, Vector3d vector2) {
        double x = Mth.m_14139_((double)ratio, (double)vector1.f_86214_, (double)vector2.f_86214_);
        double y = Mth.m_14139_((double)ratio, (double)vector1.f_86215_, (double)vector2.f_86215_);
        double z = Mth.m_14139_((double)ratio, (double)vector1.f_86216_, (double)vector2.f_86216_);
        return new Vector3d(x, y, z);
    }

    public static Vec3 lerp(double ratio, Vec3 vector1, Vec3 vector2) {
        double x = Mth.m_14139_((double)ratio, (double)vector1.f_82479_, (double)vector2.f_82479_);
        double y = Mth.m_14139_((double)ratio, (double)vector1.f_82480_, (double)vector2.f_82480_);
        double z = Mth.m_14139_((double)ratio, (double)vector1.f_82481_, (double)vector2.f_82481_);
        return new Vec3(x, y, z);
    }

    public static Vec3 convertToVec3(BlockPos blockPosition) {
        return new Vec3((double)blockPosition.m_123341_() + 0.5, (double)blockPosition.m_123342_() + 0.5, (double)blockPosition.m_123343_() + 0.5);
    }
}

