/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimpleParticle
extends TextureSheetParticle {
    protected final double yOffset;
    protected IFormula<Double> xdFormula = xd -> xd * 0.95;
    protected IFormula<Double> ydFormula = yd -> yd - 0.0375;
    protected IFormula<Double> zdFormula = zd -> zd * 0.95;
    protected IFormula<Double> xdOnGroundFormula = xd -> xd * 0.5;
    protected IFormula<Double> ydOnGroundFormula = yd -> yd;
    protected IFormula<Double> zdOnGroundFormula = zd -> zd * 0.5;
    protected IFormula<Float> alphaFormula = alpha -> alpha;
    protected IFormula<Float> scaleFormula = lifeRatio -> Float.valueOf(1.0f - 0.5f * lifeRatio.floatValue());

    public SimpleParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet, double yOffset) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.yOffset = yOffset;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (++this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ = this.xdFormula.apply(this.f_107215_);
            this.f_107216_ = this.ydFormula.apply(this.f_107216_);
            this.f_107217_ = this.zdFormula.apply(this.f_107217_);
            if (this.f_107218_) {
                this.f_107215_ = this.xdOnGroundFormula.apply(this.f_107215_);
                this.f_107216_ = this.ydOnGroundFormula.apply(this.f_107216_);
                this.f_107217_ = this.zdOnGroundFormula.apply(this.f_107217_);
            }
            this.f_107230_ = this.alphaFormula.apply(Float.valueOf(this.f_107230_)).floatValue();
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float scaleFactor) {
        Quaternion quaternion;
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)scaleFactor, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)scaleFactor, (double)(this.f_107210_ + this.yOffset), (double)(this.f_107213_ + this.yOffset)) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)scaleFactor, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = camera.m_90591_();
        } else {
            quaternion = new Quaternion(camera.m_90591_());
            float f3 = Mth.m_14179_((float)scaleFactor, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.m_80148_(Vector3f.f_122227_.m_122270_(f3));
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.m_122251_(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.m_5902_(scaleFactor);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.m_122251_(quaternion);
            vector3f.m_122261_(f4);
            vector3f.m_122272_(f, f1, f2);
        }
        float f7 = this.m_5970_();
        float f8 = this.m_5952_();
        float f5 = this.m_5951_();
        float f6 = this.m_5950_();
        int j = this.m_6355_(scaleFactor);
        vertexConsumer.m_5483_((double)avector3f[0].m_122239_(), (double)avector3f[0].m_122260_(), (double)avector3f[0].m_122269_()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[1].m_122239_(), (double)avector3f[1].m_122260_(), (double)avector3f[1].m_122269_()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[2].m_122239_(), (double)avector3f[2].m_122260_(), (double)avector3f[2].m_122269_()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        vertexConsumer.m_5483_((double)avector3f[3].m_122239_(), (double)avector3f[3].m_122260_(), (double)avector3f[3].m_122269_()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    public float m_5902_(float scaleFactor) {
        return this.f_107663_ * this.scaleFormula.apply(Float.valueOf(((float)this.f_107224_ + scaleFactor) / (float)this.f_107225_)).floatValue();
    }

    @FunctionalInterface
    public static interface IFormula<Type> {
        public Type apply(Type var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class SimpleFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;
        private final IInstanceFactory instanceFactory;

        public SimpleFactory(SpriteSet sprite, IInstanceFactory instanceFactory) {
            this.spriteSet = sprite;
            this.instanceFactory = instanceFactory;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return this.instanceFactory.createInstance(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }

        @FunctionalInterface
        public static interface IInstanceFactory {
            public SimpleParticle createInstance(ClientLevel var1, double var2, double var4, double var6, double var8, double var10, double var12, SpriteSet var14);
        }
    }
}

