/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.time;

import com.mlib.Utility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Delay {
    static final List<Delay> PENDING_DELAYS = new ArrayList<Delay>();
    static final List<Delay> DELAYS = new ArrayList<Delay>();
    int ticksLeft;
    final ICallable callable;

    public static void onNextTick(ICallable callable) {
        new Delay(0, callable);
    }

    public Delay(int ticks, ICallable callable) {
        this.ticksLeft = ticks;
        this.callable = callable;
        PENDING_DELAYS.add(this);
    }

    public Delay(double seconds, ICallable callable) {
        this(Utility.secondsToTicks(seconds), callable);
    }

    public boolean isAboutToGetCalled() {
        return this.ticksLeft <= 0;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        DELAYS.addAll(PENDING_DELAYS);
        PENDING_DELAYS.clear();
        Iterator<Delay> iterator = DELAYS.iterator();
        while (iterator.hasNext()) {
            Delay delay = iterator.next();
            if (delay.isAboutToGetCalled()) {
                delay.callable.call();
                iterator.remove();
                continue;
            }
            --delay.ticksLeft;
        }
    }

    public static interface ICallable {
        public void call();
    }
}

