/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.time;

import com.mlib.Utility;
import com.mlib.config.DoubleConfig;
import javax.annotation.Nonnegative;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TimeHelper {
    private static long clientCounter = 1L;
    private static long serverCounter = 1L;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.ClientTickEvent event) {
        if (TimeHelper.isEndPhase((TickEvent)event)) {
            ++clientCounter;
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (TimeHelper.isEndPhase((TickEvent)event)) {
            ++serverCounter;
        }
    }

    public static boolean isEndPhase(TickEvent event) {
        return event.phase == TickEvent.Phase.END;
    }

    public static boolean hasClientTicksPassed(@Nonnegative int tickDelay) {
        return clientCounter % (long)tickDelay == 0L;
    }

    public static boolean hasClientSecondsPassed(@Nonnegative double secondDelay) {
        return TimeHelper.hasClientTicksPassed(Utility.secondsToTicks(secondDelay));
    }

    public static boolean hasClientSecondsPassed(DoubleConfig config) {
        return TimeHelper.hasClientTicksPassed(config.asTicks());
    }

    public static boolean hasServerTicksPassed(@Nonnegative int tickDelay) {
        return serverCounter % (long)tickDelay == 0L;
    }

    public static boolean hasServerSecondsPassed(@Nonnegative double secondDelay) {
        return TimeHelper.hasServerTicksPassed(Utility.secondsToTicks(secondDelay));
    }

    public static boolean hasServerSecondsPassed(DoubleConfig config) {
        return TimeHelper.hasServerTicksPassed(config.asTicks());
    }
}

