/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty;

import com.majruszsdifficulty.Registries;
import com.mlib.levels.LevelHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GameStage {
    public static final ChatFormatting NORMAL_MODE_COLOR = ChatFormatting.WHITE;
    public static final ChatFormatting EXPERT_MODE_COLOR = ChatFormatting.RED;
    public static final ChatFormatting MASTER_MODE_COLOR = ChatFormatting.DARK_PURPLE;
    private static Stage CURRENT = Stage.NORMAL;

    public static boolean changeMode(Stage stage) {
        if (stage == CURRENT) {
            return false;
        }
        CURRENT = stage;
        return true;
    }

    public static boolean changeModeWithAdvancement(Stage stage, MinecraftServer minecraftServer) {
        if (!GameStage.changeMode(stage)) {
            return false;
        }
        GameStage.triggerAdvancementForAllPlayers(minecraftServer);
        return true;
    }

    public static void triggerAdvancementForAllPlayers(MinecraftServer minecraftServer) {
        minecraftServer.m_6846_().m_11314_().forEach(GameStage::triggerAdvancement);
    }

    public static void triggerAdvancement(ServerPlayer player) {
        Registries.GAME_STATE_TRIGGER.trigger(player, CURRENT);
    }

    public static Stage getCurrentStage() {
        return CURRENT;
    }

    public static boolean atLeast(Stage stage) {
        return GameStage.getGameStageDependentValue(stage, true, CURRENT == Stage.EXPERT || CURRENT == Stage.MASTER, CURRENT == Stage.MASTER);
    }

    public static int convertStageToInteger(Stage stage) {
        return GameStage.getGameStageDependentValue(stage, 0, 1, 2);
    }

    public static Stage convertIntegerToStage(int mode) {
        return switch (mode) {
            default -> Stage.NORMAL;
            case 1 -> Stage.EXPERT;
            case 2 -> Stage.MASTER;
        };
    }

    public static ChatFormatting getChatFormatting(Stage stage) {
        return GameStage.getGameStageDependentValue(stage, ChatFormatting.WHITE, ChatFormatting.RED, ChatFormatting.DARK_PURPLE);
    }

    public static <ConfigType> ConfigType getGameStageDependentValue(Stage stage, ConfigType normal, ConfigType expert, ConfigType master) {
        return switch (stage) {
            default -> normal;
            case Stage.EXPERT -> expert;
            case Stage.MASTER -> master;
        };
    }

    public static <ConfigType> ConfigType getCurrentGameStageDependentValue(ConfigType normal, ConfigType expert, ConfigType master) {
        return GameStage.getGameStageDependentValue(CURRENT, normal, expert, master);
    }

    public static MutableComponent getGameStageText(Stage stage) {
        String gameStageId = GameStage.getGameStageDependentValue(stage, "normal", "expert", "master");
        return GameStage.constructGameStageText(gameStageId, GameStage.getChatFormatting(stage));
    }

    public static double getRegionalDifficulty(LivingEntity target) {
        double clampedRegionalDifficulty = target != null ? LevelHelper.getClampedRegionalDifficulty((Entity)target) : 0.25;
        return Mth.m_14008_((double)(clampedRegionalDifficulty + GameStage.getStageModifier()), (double)0.0, (double)1.0);
    }

    public static double getRegionalDifficulty(Level level, Vec3 position) {
        double clampedRegionalDifficulty = LevelHelper.getClampedRegionalDifficulty((Level)level, (Vec3)position);
        return Mth.m_14008_((double)(clampedRegionalDifficulty + GameStage.getStageModifier()), (double)0.0, (double)1.0);
    }

    public static double getStageModifier() {
        return GameStage.getCurrentGameStageDependentValue(0.0, 0.15, 0.3);
    }

    private static MutableComponent constructGameStageText(String stage, ChatFormatting color) {
        return Component.m_237115_((String)("majruszsdifficulty.stages." + stage)).m_130944_(new ChatFormatting[]{color, ChatFormatting.BOLD});
    }

    public static enum Stage {
        NORMAL,
        EXPERT,
        MASTER;

    }

    public record Double(double normal, double expert, double master) {
    }

    public record Integer(int normal, int expert, int master) {
    }
}

