/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.config.GameStageStringListConfig;
import com.majruszsdifficulty.gamemodifiers.DifficultyModifier;
import com.mlib.config.UserConfig;
import com.mlib.gamemodifiers.Context;
import com.mlib.gamemodifiers.contexts.OnCheckSpawnContext;
import com.mlib.gamemodifiers.data.OnCheckSpawnData;
import com.mlib.levels.LevelHelper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class SpawnBlocker
extends DifficultyModifier {
    final GameStageStringListConfig forbiddenEntities = new GameStageStringListConfig("", "", new String[]{"minecraft:illusioner", "majruszsdifficulty:tank"}, new String[0], new String[0]);

    public SpawnBlocker() {
        super(DifficultyModifier.DEFAULT, "SpawnBlocker", "Blocks certain mobs from spawning when given game stage is active.");
        OnCheckSpawnContext onCheckSpawn = new OnCheckSpawnContext(this::blockSpawn);
        onCheckSpawn.addCondition(data -> data.entity instanceof Illusioner && SpawnBlocker.isVillageNearby((Entity)data.entity)).addCondition(data -> this.isForbidden((Entity)data.entity)).addConfig((UserConfig)this.forbiddenEntities);
        this.addContext((Context)onCheckSpawn);
    }

    private void blockSpawn(OnCheckSpawnData data) {
        ((LivingSpawnEvent.CheckSpawn)data.event).setResult(Event.Result.DENY);
    }

    private boolean isForbidden(Entity entity) {
        return this.forbiddenEntities.getCurrentGameStageValue().contains(Registry.f_122826_.m_7981_((Object)entity.m_6095_()).toString());
    }

    private static boolean isVillageNearby(Entity entity) {
        ServerLevel level;
        block3: {
            block2: {
                Level level2 = entity.f_19853_;
                if (!(level2 instanceof ServerLevel)) break block2;
                level = (ServerLevel)level2;
                if (LevelHelper.isEntityIn((Entity)entity, (ResourceKey)Level.f_46428_)) break block3;
            }
            return false;
        }
        return level.m_215011_(StructureTags.f_215889_, entity.m_20183_(), 100, false) != null;
    }
}

