/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.itemsets;

import java.util.function.Predicate;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;

public class ItemData {
    public final Predicate<ItemStack> condition;
    public final INameGetter nameGetter;
    public final EquipmentSlot[] equipmentSlots;

    public ItemData(Predicate<ItemStack> condition, INameGetter nameGetter, EquipmentSlot ... equipmentSlots) {
        this.condition = condition;
        this.nameGetter = nameGetter;
        this.equipmentSlots = equipmentSlots;
    }

    public ItemData(Item item, EquipmentSlot ... equipmentSlots) {
        this((ItemStack itemStack) -> item.equals(itemStack.m_41720_()), () -> item.m_41466_().m_6881_(), equipmentSlots);
    }

    public ItemData(RegistryObject<? extends Item> item, EquipmentSlot ... equipmentSlots) {
        this((ItemStack itemStack) -> ((Item)item.get()).equals(itemStack.m_41720_()), () -> ((Item)item.get()).m_41466_().m_6881_(), equipmentSlots);
    }

    public boolean hasItemEquipped(Player player) {
        for (EquipmentSlot equipmentSlot : this.equipmentSlots) {
            if (!this.isSetItemStack(player.m_6844_(equipmentSlot))) continue;
            return true;
        }
        return false;
    }

    public boolean isSetItemStack(ItemStack itemStack) {
        return this.condition.test(itemStack);
    }

    public MutableComponent getTranslatedName() {
        return this.nameGetter.getName();
    }

    public static interface INameGetter {
        public MutableComponent getName();
    }
}

