/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.itemsets;

public class Parameter {
    final IValueProvider value;
    final IFormat format;

    public Parameter(IValueProvider value, IFormat format) {
        this.value = value;
        this.format = format;
    }

    public static Parameter asFloat(IValueProvider valueProvider) {
        return new Parameter(valueProvider, param -> {
            float value = param.asFloat();
            if ((float)Math.round(value) == value) {
                return String.format("%.0f", Float.valueOf(value));
            }
            if (value > 1.0f) {
                return String.format("%.1f", Float.valueOf(value));
            }
            return String.format("%.2f", Float.valueOf(value));
        });
    }

    public static Parameter asFloat(float value) {
        return Parameter.asFloat(() -> Float.valueOf(value));
    }

    public static Parameter asSeconds(float value) {
        return Parameter.asFloat(() -> Float.valueOf(value));
    }

    public static Parameter asPercent(IValueProvider valueProvider) {
        return new Parameter(valueProvider, param -> {
            float value = param.asFloat() * 100.0f;
            if ((float)Math.round(value) == value) {
                return String.format("%.0f%%", Float.valueOf(value));
            }
            if (value > 1.0f) {
                return String.format("%.1f%%", Float.valueOf(value));
            }
            return String.format("%.2f%%", Float.valueOf(value));
        });
    }

    public static Parameter asPercent(float value) {
        return Parameter.asPercent(() -> Float.valueOf(value));
    }

    public static Parameter asInteger(IValueProvider valueProvider) {
        return new Parameter(valueProvider, param -> String.format("%d", param.asInt()));
    }

    public static Parameter asInteger(int value) {
        return Parameter.asInteger(() -> value);
    }

    public Number getValue() {
        return this.value.get();
    }

    public int asInt() {
        return this.getValue().intValue();
    }

    public float asFloat() {
        return this.getValue().floatValue();
    }

    public String getFormat() {
        return this.format.getFormat(this);
    }

    public static interface IValueProvider {
        public Number get();
    }

    public static interface IFormat {
        public String getFormat(Parameter var1);
    }
}

