/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.lootmodifiers;

import com.google.common.base.Suppliers;
import com.majruszsdifficulty.GameStage;
import com.mlib.Random;
import com.mlib.loot_modifiers.LootHelper;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class DoubleLoot
extends LootModifier {
    public static final Supplier<Codec<DoubleLoot>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> DoubleLoot.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, DoubleLoot::new)));
    final double normalModeChance = 0.0;
    final double expertModeChance = 0.2;
    final double masterModeChance = 0.4;
    final List<Item> forbiddenItemsToDuplicate = new ArrayList<Item>();

    public DoubleLoot(LootItemCondition[] conditions) {
        super(conditions);
        this.forbiddenItemsToDuplicate.add(Items.f_42686_);
        this.forbiddenItemsToDuplicate.add(Items.f_42747_);
    }

    @Nonnull
    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        double chance = GameStage.getCurrentGameStageDependentValue(this.normalModeChance, this.expertModeChance, this.masterModeChance);
        if (Random.tryChance((double)chance)) {
            Entity entity = (Entity)LootHelper.getParameter((LootContext)context, (LootContextParam)LootContextParams.f_81455_);
            if (generatedLoot.size() > 1 && !((ItemStack)generatedLoot.get(0)).m_41619_() && entity != null) {
                this.sendParticles(entity);
                return this.doubleLoot(generatedLoot);
            }
        }
        return generatedLoot;
    }

    protected void sendParticles(Entity entity) {
        Level level = entity.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (int i = 0; i < 8; ++i) {
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), 1, 0.5, 0.5, 0.5, 0.5);
        }
    }

    protected ObjectArrayList<ItemStack> doubleLoot(ObjectArrayList<ItemStack> generatedLoot) {
        ObjectArrayList doubledLoot = new ObjectArrayList();
        for (ItemStack itemStack : generatedLoot) {
            boolean isItemForbidden = this.isForbidden(itemStack.m_41720_());
            for (int i = 0; !(i >= 2 || i >= 1 && isItemForbidden); ++i) {
                doubledLoot.add((Object)itemStack);
            }
        }
        return doubledLoot;
    }

    protected boolean isForbidden(Item item) {
        for (Item forbidden : this.forbiddenItemsToDuplicate) {
            if (!forbidden.equals(item)) continue;
            return true;
        }
        return false;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

