/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.StringListConfig;
import com.mlib.config.UserConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.entity.EntityType;

public class WaveMembersConfig
extends ConfigGroup {
    public WaveMembersConfig(String name, String comment) {
        super(name, comment, new UserConfig[0]);
    }

    public void addWaveConfig(String ... defaultValues) {
        this.configs.add(new StringListConfig("wave_" + (this.configs.size() + 1), "", false, defaultValues));
    }

    public List<WaveMember> getWaveMembers(int waveNumber) {
        StringListConfig waveStringConfig = (StringListConfig)this.configs.get(waveNumber - 1);
        ArrayList<WaveMember> waveMembers = new ArrayList<WaveMember>();
        for (String config : (List)waveStringConfig.get()) {
            Optional optionalEntityType;
            Pattern pattern = Pattern.compile("(.*)-(.*) (.*)");
            Matcher matcher = pattern.matcher(config);
            if (!matcher.find() || !(optionalEntityType = EntityType.m_20632_((String)matcher.group(3))).isPresent()) continue;
            int minAmount = Integer.parseInt(matcher.group(1));
            int maxAmount = Integer.parseInt(matcher.group(2));
            WaveMember waveMember = new WaveMember(Random.nextInt((int)minAmount, (int)(maxAmount + 1)), (EntityType)optionalEntityType.get());
            if (waveMember.amount <= 0) continue;
            waveMembers.add(waveMember);
        }
        return waveMembers;
    }

    public record WaveMember(int amount, EntityType<?> entityType) {
    }
}

