/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty;

import com.majruszsdifficulty.GameDataSaver;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.PacketHandler;
import com.majruszsdifficulty.RegistriesClient;
import com.majruszsdifficulty.blocks.EndShardOre;
import com.majruszsdifficulty.blocks.EnderiumBlock;
import com.majruszsdifficulty.blocks.InfestedEndStone;
import com.majruszsdifficulty.commands.CommandsHelper;
import com.majruszsdifficulty.effects.BleedingEffect;
import com.majruszsdifficulty.effects.BleedingImmunityEffect;
import com.majruszsdifficulty.entities.CreeperlingEntity;
import com.majruszsdifficulty.entities.TankEntity;
import com.majruszsdifficulty.gamemodifiers.list.BiteBleeding;
import com.majruszsdifficulty.gamemodifiers.list.BlockIllusionerFromJoiningRaids;
import com.majruszsdifficulty.gamemodifiers.list.CactusBleeding;
import com.majruszsdifficulty.gamemodifiers.list.CreeperChainReaction;
import com.majruszsdifficulty.gamemodifiers.list.CreeperExplodeBehindWall;
import com.majruszsdifficulty.gamemodifiers.list.CreeperExplosionImmunity;
import com.majruszsdifficulty.gamemodifiers.list.CreeperSpawnCharged;
import com.majruszsdifficulty.gamemodifiers.list.CreeperSpawnDebuffed;
import com.majruszsdifficulty.gamemodifiers.list.CreeperSplitIntoCreeperlings;
import com.majruszsdifficulty.gamemodifiers.list.CreeperlingsCannotDestroyBlocks;
import com.majruszsdifficulty.gamemodifiers.list.DoubleLoot;
import com.majruszsdifficulty.gamemodifiers.list.DrownDebuffs;
import com.majruszsdifficulty.gamemodifiers.list.DrownedLightningAttack;
import com.majruszsdifficulty.gamemodifiers.list.EndermanTeleportAttack;
import com.majruszsdifficulty.gamemodifiers.list.EvokerWithTotem;
import com.majruszsdifficulty.gamemodifiers.list.ExperienceBonus;
import com.majruszsdifficulty.gamemodifiers.list.FallDebuffs;
import com.majruszsdifficulty.gamemodifiers.list.IncreaseGameStage;
import com.majruszsdifficulty.gamemodifiers.list.JockeySpawn;
import com.majruszsdifficulty.gamemodifiers.list.MobsSpawnStronger;
import com.majruszsdifficulty.gamemodifiers.list.PhantomLevitationAttack;
import com.majruszsdifficulty.gamemodifiers.list.PiglinsInGroup;
import com.majruszsdifficulty.gamemodifiers.list.PowerfulExplosions;
import com.majruszsdifficulty.gamemodifiers.list.SharpToolsBleeding;
import com.majruszsdifficulty.gamemodifiers.list.ShulkerBlindnessAttack;
import com.majruszsdifficulty.gamemodifiers.list.SkeletonsInGroup;
import com.majruszsdifficulty.gamemodifiers.list.SlimeSlownessAttack;
import com.majruszsdifficulty.gamemodifiers.list.SpawnBlocker;
import com.majruszsdifficulty.gamemodifiers.list.SpawnPlayerZombie;
import com.majruszsdifficulty.gamemodifiers.list.SpiderPoisonAttack;
import com.majruszsdifficulty.gamemodifiers.list.ThrowableWeaponsBleeding;
import com.majruszsdifficulty.gamemodifiers.list.WitherSkeletonWithSword;
import com.majruszsdifficulty.gamemodifiers.list.ZombiesInGroup;
import com.majruszsdifficulty.items.BandageItem;
import com.majruszsdifficulty.items.ClothItem;
import com.majruszsdifficulty.items.EndShardItem;
import com.majruszsdifficulty.items.EndShardLocatorItem;
import com.majruszsdifficulty.items.EnderiumArmorItem;
import com.majruszsdifficulty.items.EnderiumAxeItem;
import com.majruszsdifficulty.items.EnderiumHoeItem;
import com.majruszsdifficulty.items.EnderiumIngotItem;
import com.majruszsdifficulty.items.EnderiumPickaxeItem;
import com.majruszsdifficulty.items.EnderiumShovelItem;
import com.majruszsdifficulty.items.EnderiumSwordItem;
import com.majruszsdifficulty.items.FakeItem;
import com.majruszsdifficulty.items.GoldenBandageItem;
import com.majruszsdifficulty.items.RecallPotionItem;
import com.majruszsdifficulty.items.TreasureBagItem;
import com.majruszsdifficulty.items.UndeadBattleStandardItem;
import com.majruszsdifficulty.items.WitherSwordItem;
import com.majruszsdifficulty.itemsets.EnderiumSet;
import com.majruszsdifficulty.itemsets.UndeadSet;
import com.majruszsdifficulty.treasurebags.LootProgressManager;
import com.majruszsdifficulty.treasurebags.TreasureBagManager;
import com.majruszsdifficulty.triggers.BandageTrigger;
import com.majruszsdifficulty.triggers.GameStageTrigger;
import com.majruszsdifficulty.triggers.TreasureBagTrigger;
import com.majruszsdifficulty.triggers.UndeadArmyDefeatedTrigger;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import com.majruszsdifficulty.undeadarmy.UndeadArmyEventsHandler;
import com.majruszsdifficulty.undeadarmy.UndeadArmyManager;
import com.majruszsdifficulty.world.WorldGenHelper;
import com.mlib.commands.IRegistrableCommand;
import com.mlib.config.ConfigGroup;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.items.ItemCreativeModeTab;
import com.mlib.registries.DeferredRegisterHelper;
import com.mlib.triggers.BasicTrigger;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class Registries {
    private static final DeferredRegisterHelper HELPER;
    public static final ConfigGroup UNDEAD_ARMY_GROUP;
    static final DeferredRegister<Block> BLOCKS;
    static final DeferredRegister<Item> ITEMS;
    static final DeferredRegister<EntityType<?>> ENTITY_TYPES;
    static final DeferredRegister<MobEffect> MOB_EFFECTS;
    static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES;
    static final DeferredRegister<SoundEvent> SOUNDS_EVENTS;
    static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS;
    static final DeferredRegister<PlacedFeature> PLACED_FEATURES;
    static final DeferredRegister<ConfiguredFeature<?, ?>> CONFIGURED_FEATURES;
    static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIERS;
    public static final RegistryObject<EntityType<CreeperlingEntity>> CREEPERLING;
    public static final RegistryObject<EntityType<TankEntity>> TANK;
    public static final RegistryObject<BandageItem> BANDAGE;
    public static final RegistryObject<GoldenBandageItem> GOLDEN_BANDAGE;
    public static final RegistryObject<ClothItem> CLOTH;
    public static final RegistryObject<UndeadBattleStandardItem> BATTLE_STANDARD;
    public static final RegistryObject<EnderiumArmorItem> ENDERIUM_HELMET;
    public static final RegistryObject<EnderiumArmorItem> ENDERIUM_CHESTPLATE;
    public static final RegistryObject<EnderiumArmorItem> ENDERIUM_LEGGINGS;
    public static final RegistryObject<EnderiumArmorItem> ENDERIUM_BOOTS;
    public static final RegistryObject<EndShardItem> ENDERIUM_SHARD;
    public static final RegistryObject<EnderiumIngotItem> ENDERIUM_INGOT;
    public static final RegistryObject<EndShardLocatorItem> ENDERIUM_SHARD_LOCATOR;
    public static final RegistryObject<EnderiumSwordItem> ENDERIUM_SWORD;
    public static final RegistryObject<EnderiumPickaxeItem> ENDERIUM_PICKAXE;
    public static final RegistryObject<EnderiumAxeItem> ENDERIUM_AXE;
    public static final RegistryObject<EnderiumShovelItem> ENDERIUM_SHOVEL;
    public static final RegistryObject<EnderiumHoeItem> ENDERIUM_HOE;
    public static final RegistryObject<WitherSwordItem> WITHER_SWORD;
    public static final RegistryObject<RecallPotionItem> RECALL_POTION;
    public static final RegistryObject<TreasureBagItem> UNDEAD_ARMY_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> ELDER_GUARDIAN_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> WITHER_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> ENDER_DRAGON_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> FISHING_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> PILLAGER_TREASURE_BAG;
    public static final RegistryObject<TreasureBagItem> WARDEN_TREASURE_BAG;
    public static final RegistryObject<EndShardOre.EndShardOreItem> ENDERIUM_SHARD_ORE_ITEM;
    public static final RegistryObject<EnderiumBlock.EndBlockItem> ENDERIUM_BLOCK_ITEM;
    public static final RegistryObject<InfestedEndStone.InfestedEndStoneItem> INFESTED_END_STONE_ITEM;
    public static final RegistryObject<SpawnEggItem> ILLUSIONER_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> CREEPERLING_SPAWN_EGG;
    public static final RegistryObject<SpawnEggItem> TANK_SPAWN_EGG;
    public static final EnderiumSet ENDERIUM_SET;
    public static final UndeadSet UNDEAD_SET;
    public static final RegistryObject<EndShardOre> ENDERIUM_SHARD_ORE;
    public static final RegistryObject<EnderiumBlock> ENDERIUM_BLOCK;
    public static final RegistryObject<InfestedEndStone> INFESTED_END_STONE;
    public static final RegistryObject<BleedingEffect> BLEEDING;
    public static final RegistryObject<BleedingImmunityEffect> BLEEDING_IMMUNITY;
    public static final DamageSource BLEEDING_SOURCE;
    public static final RegistryObject<SimpleParticleType> BLOOD;
    public static final CreativeModeTab ITEM_GROUP;
    public static UndeadArmyManager UNDEAD_ARMY_MANAGER;
    public static GameDataSaver GAME_DATA_SAVER;
    public static final GameStageTrigger GAME_STATE_TRIGGER;
    public static final TreasureBagTrigger TREASURE_BAG_TRIGGER;
    public static final UndeadArmyDefeatedTrigger UNDEAD_ARMY_DEFEATED_TRIGGER;
    public static final BandageTrigger BANDAGE_TRIGGER;
    public static final BasicTrigger BASIC_TRIGGER;
    public static final RegistryObject<ConfiguredFeature<?, ?>> ENDERIUM_ORE_SMALL_CONFIGURED;
    public static final RegistryObject<ConfiguredFeature<?, ?>> ENDERIUM_ORE_LARGE_CONFIGURED;
    public static final RegistryObject<ConfiguredFeature<?, ?>> INFESTED_END_STONE_CONFIGURED;
    public static final RegistryObject<PlacedFeature> ENDERIUM_ORE_SMALL_PLACED;
    public static final RegistryObject<PlacedFeature> ENDERIUM_ORE_LARGE_PLACED;
    public static final RegistryObject<PlacedFeature> INFESTED_END_STONE_PLACED;
    public static final RegistryObject<SoundEvent> UNDEAD_ARMY_APPROACHING;
    public static final RegistryObject<SoundEvent> UNDEAD_ARMY_WAVE_STARTED;
    public static final List<GameModifier> GAME_MODIFIERS;

    static Supplier<SpawnEggItem> createEggSupplier(Supplier<? extends EntityType<? extends Mob>> type, int backgroundColor, int highlightColor) {
        return () -> new ForgeSpawnEggItem(type, backgroundColor, highlightColor, new Item.Properties().m_41491_(ITEM_GROUP));
    }

    static RegistryObject<SoundEvent> register(String name) {
        return SOUNDS_EVENTS.register(name, () -> new SoundEvent(Registries.getLocation(name)));
    }

    public static ResourceLocation getLocation(String register) {
        return HELPER.getLocation(register);
    }

    public static String getLocationString(String register) {
        return Registries.getLocation(register).toString();
    }

    public static void initialize() {
        FMLJavaModLoadingContext loadingContext = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = loadingContext.getModEventBus();
        HELPER.registerAll();
        modEventBus.addListener(Registries::setup);
        modEventBus.addListener(Registries::setupClient);
        modEventBus.addListener(Registries::setupEntities);
        modEventBus.addListener(PacketHandler::registerPacket);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(Registries::onLoadingLevel);
        forgeEventBus.addListener(Registries::onSavingLevel);
        forgeEventBus.addListener(Registries::registerCommands);
        MajruszsDifficulty.SERVER_CONFIG.register(ModLoadingContext.get());
    }

    private static void setupClient(FMLClientSetupEvent event) {
        RegistriesClient.setup();
    }

    public static void setupEntities(EntityAttributeCreationEvent event) {
        event.put((EntityType)CREEPERLING.get(), CreeperlingEntity.getAttributeMap());
        event.put((EntityType)TANK.get(), TankEntity.getAttributeMap());
    }

    private static void setup(FMLCommonSetupEvent event) {
        SpawnPlacements.m_21754_((EntityType)((EntityType)CREEPERLING.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)TANK.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
    }

    private static void registerCommands(RegisterCommandsEvent event) {
        for (IRegistrableCommand command : CommandsHelper.COMMANDS) {
            command.register(event.getDispatcher());
        }
    }

    public static void onLoadingLevel(LevelEvent.Load event) {
        ServerLevel level = Registries.getOverworld(event.getLevel());
        if (level == null) {
            return;
        }
        DimensionDataStorage manager = level.m_8895_();
        UNDEAD_ARMY_MANAGER = (UndeadArmyManager)manager.m_164861_(nbt -> UndeadArmyManager.load(nbt, level), () -> new UndeadArmyManager(level), "undead_army");
        GAME_DATA_SAVER = (GameDataSaver)manager.m_164861_(GameDataSaver::load, GameDataSaver::new, "majruszsdifficulty");
        TreasureBagManager.addTreasureBagTo(EntityType.f_20563_, (TreasureBagItem)((Object)ELDER_GUARDIAN_TREASURE_BAG.get()));
        TreasureBagManager.addTreasureBagTo(EntityType.f_20496_, (TreasureBagItem)((Object)WITHER_TREASURE_BAG.get()));
        TreasureBagManager.addTreasureBagTo(EntityType.f_20565_, (TreasureBagItem)((Object)ENDER_DRAGON_TREASURE_BAG.get()));
        TreasureBagManager.addTreasureBagTo(EntityType.f_217015_, (TreasureBagItem)((Object)WARDEN_TREASURE_BAG.get()));
    }

    public static void onSavingLevel(LevelEvent.Save event) {
        ServerLevel level = Registries.getOverworld(event.getLevel());
        if (level == null) {
            return;
        }
        GAME_DATA_SAVER.m_77762_();
        UNDEAD_ARMY_MANAGER.m_77762_();
    }

    @Nullable
    private static ServerLevel getOverworld(LevelAccessor levelAccessor) {
        ServerLevel overworld = levelAccessor.m_7654_() != null ? levelAccessor.m_7654_().m_129880_(Level.f_46428_) : null;
        return levelAccessor.equals(overworld) ? overworld : null;
    }

    static {
        String[] fakeItemNames;
        HELPER = new DeferredRegisterHelper("majruszsdifficulty");
        MajruszsDifficulty.SERVER_CONFIG.addGroup(GameModifier.addNewGroup((String)Modifiers.DEFAULT));
        UNDEAD_ARMY_GROUP = GameModifier.addNewGroup((String)Modifiers.UNDEAD_ARMY, (String)"UndeadArmy", (String)"");
        MajruszsDifficulty.SERVER_CONFIG.addGroup(UNDEAD_ARMY_GROUP);
        MajruszsDifficulty.SERVER_CONFIG.addGroup(GameModifier.addNewGroup((String)Modifiers.GAME_STAGE, (String)"GameStage", (String)""));
        MajruszsDifficulty.SERVER_CONFIG.addGroup(GameModifier.addNewGroup((String)Modifiers.TREASURE_BAG, (String)"TreasureBag", (String)""));
        BLOCKS = HELPER.create(ForgeRegistries.Keys.BLOCKS);
        ITEMS = HELPER.create(ForgeRegistries.Keys.ITEMS);
        ENTITY_TYPES = HELPER.create(ForgeRegistries.Keys.ENTITY_TYPES);
        MOB_EFFECTS = HELPER.create(ForgeRegistries.Keys.MOB_EFFECTS);
        PARTICLE_TYPES = HELPER.create(ForgeRegistries.Keys.PARTICLE_TYPES);
        SOUNDS_EVENTS = HELPER.create(ForgeRegistries.Keys.SOUND_EVENTS);
        LOOT_MODIFIERS = HELPER.create(ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS);
        PLACED_FEATURES = HELPER.create(Registry.f_194567_);
        CONFIGURED_FEATURES = HELPER.create(Registry.f_122881_);
        BIOME_MODIFIERS = HELPER.create(ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS);
        CREEPERLING = ENTITY_TYPES.register("creeperling", CreeperlingEntity.createSupplier());
        TANK = ENTITY_TYPES.register("tank", TankEntity.createSupplier());
        BANDAGE = ITEMS.register("bandage", BandageItem::new);
        GOLDEN_BANDAGE = ITEMS.register("golden_bandage", GoldenBandageItem::new);
        CLOTH = ITEMS.register("cloth", ClothItem::new);
        BATTLE_STANDARD = ITEMS.register("undead_battle_standard", UndeadBattleStandardItem::new);
        ENDERIUM_HELMET = ITEMS.register("enderium_helmet", EnderiumArmorItem.Helmet::new);
        ENDERIUM_CHESTPLATE = ITEMS.register("enderium_chestplate", EnderiumArmorItem.Chestplate::new);
        ENDERIUM_LEGGINGS = ITEMS.register("enderium_leggings", EnderiumArmorItem.Leggings::new);
        ENDERIUM_BOOTS = ITEMS.register("enderium_boots", EnderiumArmorItem.Boots::new);
        ENDERIUM_SHARD = ITEMS.register("enderium_shard", EndShardItem::new);
        ENDERIUM_INGOT = ITEMS.register("enderium_ingot", EnderiumIngotItem::new);
        ENDERIUM_SHARD_LOCATOR = ITEMS.register("enderium_shard_locator", EndShardLocatorItem::new);
        ENDERIUM_SWORD = ITEMS.register("enderium_sword", EnderiumSwordItem::new);
        ENDERIUM_PICKAXE = ITEMS.register("enderium_pickaxe", EnderiumPickaxeItem::new);
        ENDERIUM_AXE = ITEMS.register("enderium_axe", EnderiumAxeItem::new);
        ENDERIUM_SHOVEL = ITEMS.register("enderium_shovel", EnderiumShovelItem::new);
        ENDERIUM_HOE = ITEMS.register("enderium_hoe", EnderiumHoeItem::new);
        WITHER_SWORD = ITEMS.register("wither_sword", WitherSwordItem::new);
        RECALL_POTION = ITEMS.register("recall_potion", RecallPotionItem::new);
        UNDEAD_ARMY_TREASURE_BAG = ITEMS.register("undead_army_treasure_bag", TreasureBagItem.UndeadArmy::new);
        ELDER_GUARDIAN_TREASURE_BAG = ITEMS.register("elder_guardian_treasure_bag", TreasureBagItem.ElderGuardian::new);
        WITHER_TREASURE_BAG = ITEMS.register("wither_treasure_bag", TreasureBagItem.Wither::new);
        ENDER_DRAGON_TREASURE_BAG = ITEMS.register("ender_dragon_treasure_bag", TreasureBagItem.EnderDragon::new);
        FISHING_TREASURE_BAG = ITEMS.register("fishing_treasure_bag", TreasureBagItem.Fishing::new);
        PILLAGER_TREASURE_BAG = ITEMS.register("pillager_treasure_bag", TreasureBagItem.Pillager::new);
        WARDEN_TREASURE_BAG = ITEMS.register("warden_treasure_bag", TreasureBagItem.Warden::new);
        ENDERIUM_SHARD_ORE_ITEM = ITEMS.register("enderium_shard_ore", EndShardOre.EndShardOreItem::new);
        ENDERIUM_BLOCK_ITEM = ITEMS.register("enderium_block", EnderiumBlock.EndBlockItem::new);
        INFESTED_END_STONE_ITEM = ITEMS.register("infested_end_stone", InfestedEndStone.InfestedEndStoneItem::new);
        ILLUSIONER_SPAWN_EGG = ITEMS.register("illusioner_spawn_egg", Registries.createEggSupplier(() -> EntityType.f_20459_, 1268375, 0x959B9B));
        CREEPERLING_SPAWN_EGG = ITEMS.register("creeperling_spawn_egg", Registries.createEggSupplier(CREEPERLING, 894731, 0));
        TANK_SPAWN_EGG = ITEMS.register("tank_spawn_egg", Registries.createEggSupplier(TANK, 0xC1C1C1, 0x949494));
        for (String name : fakeItemNames = new String[]{"normal", "expert", "master", "bleeding"}) {
            ITEMS.register("advancement_" + name, FakeItem::new);
        }
        ENDERIUM_SET = new EnderiumSet();
        UNDEAD_SET = new UndeadSet();
        ENDERIUM_SHARD_ORE = BLOCKS.register("enderium_shard_ore", EndShardOre::new);
        ENDERIUM_BLOCK = BLOCKS.register("enderium_block", EnderiumBlock::new);
        INFESTED_END_STONE = BLOCKS.register("infested_end_stone", InfestedEndStone::new);
        BLEEDING = MOB_EFFECTS.register("bleeding", BleedingEffect::new);
        BLEEDING_IMMUNITY = MOB_EFFECTS.register("bleeding_immunity", BleedingImmunityEffect::new);
        BLEEDING_SOURCE = new DamageSource("bleeding").m_19380_();
        BLOOD = PARTICLE_TYPES.register("blood_particle", () -> new SimpleParticleType(true));
        ITEM_GROUP = new ItemCreativeModeTab("majruszs_difficulty_tab", BATTLE_STANDARD);
        GAME_STATE_TRIGGER = (GameStageTrigger)CriteriaTriggers.m_10595_((CriterionTrigger)new GameStageTrigger());
        TREASURE_BAG_TRIGGER = (TreasureBagTrigger)CriteriaTriggers.m_10595_((CriterionTrigger)new TreasureBagTrigger());
        UNDEAD_ARMY_DEFEATED_TRIGGER = (UndeadArmyDefeatedTrigger)CriteriaTriggers.m_10595_((CriterionTrigger)new UndeadArmyDefeatedTrigger());
        BANDAGE_TRIGGER = (BandageTrigger)CriteriaTriggers.m_10595_((CriterionTrigger)new BandageTrigger());
        BASIC_TRIGGER = BasicTrigger.createRegisteredInstance((String)"majruszsdifficulty");
        ENDERIUM_ORE_SMALL_CONFIGURED = CONFIGURED_FEATURES.register("enderium_ore_small", () -> WorldGenHelper.getEndConfigured(ENDERIUM_SHARD_ORE, 1, 0.99f));
        ENDERIUM_ORE_LARGE_CONFIGURED = CONFIGURED_FEATURES.register("enderium_ore_large", () -> WorldGenHelper.getEndConfigured(ENDERIUM_SHARD_ORE, 2, 0.99f));
        INFESTED_END_STONE_CONFIGURED = CONFIGURED_FEATURES.register("infested_end_stone", () -> WorldGenHelper.getEndConfigured(INFESTED_END_STONE, 4, 0.0f));
        ENDERIUM_ORE_SMALL_PLACED = PLACED_FEATURES.register("enderium_ore_small_placed", () -> WorldGenHelper.getEnderiumPlaced(ENDERIUM_ORE_SMALL_CONFIGURED, 1));
        ENDERIUM_ORE_LARGE_PLACED = PLACED_FEATURES.register("enderium_ore_large_placed", () -> WorldGenHelper.getEnderiumPlaced(ENDERIUM_ORE_LARGE_CONFIGURED, 3));
        INFESTED_END_STONE_PLACED = PLACED_FEATURES.register("infested_end_stone_placed", () -> WorldGenHelper.getEndPlaced(INFESTED_END_STONE_CONFIGURED, 8, 255));
        UNDEAD_ARMY_APPROACHING = Registries.register("undead_army.approaching");
        UNDEAD_ARMY_WAVE_STARTED = Registries.register("undead_army.wave_started");
        GAME_MODIFIERS = new ArrayList<GameModifier>();
        GAME_MODIFIERS.add(new BandageItem.BandageUse());
        GAME_MODIFIERS.add(new BiteBleeding());
        GAME_MODIFIERS.add(new BlockIllusionerFromJoiningRaids());
        GAME_MODIFIERS.add(new CactusBleeding());
        GAME_MODIFIERS.add(new CreeperChainReaction());
        GAME_MODIFIERS.add(new CreeperExplodeBehindWall());
        GAME_MODIFIERS.add(new CreeperExplosionImmunity());
        GAME_MODIFIERS.add(new CreeperlingsCannotDestroyBlocks());
        GAME_MODIFIERS.add(new CreeperSpawnCharged());
        GAME_MODIFIERS.add(new CreeperSpawnDebuffed());
        GAME_MODIFIERS.add(new CreeperSplitIntoCreeperlings());
        GAME_MODIFIERS.add(new DoubleLoot());
        GAME_MODIFIERS.add(new DrownDebuffs());
        GAME_MODIFIERS.add(new DrownedLightningAttack());
        GAME_MODIFIERS.add(new EndermanTeleportAttack());
        GAME_MODIFIERS.add(new EvokerWithTotem());
        GAME_MODIFIERS.add(new ExperienceBonus());
        GAME_MODIFIERS.add(new FallDebuffs());
        GAME_MODIFIERS.add(new IncreaseGameStage());
        GAME_MODIFIERS.add(new JockeySpawn());
        GAME_MODIFIERS.add(new LootProgressManager());
        GAME_MODIFIERS.add(new MobsSpawnStronger());
        GAME_MODIFIERS.add(new PhantomLevitationAttack());
        GAME_MODIFIERS.add(new PiglinsInGroup());
        GAME_MODIFIERS.add(new PowerfulExplosions());
        GAME_MODIFIERS.add(new SharpToolsBleeding());
        GAME_MODIFIERS.add(new ShulkerBlindnessAttack());
        GAME_MODIFIERS.add(new SkeletonsInGroup());
        GAME_MODIFIERS.add(new SlimeSlownessAttack());
        GAME_MODIFIERS.add(new SpawnBlocker());
        GAME_MODIFIERS.add(new SpawnPlayerZombie());
        GAME_MODIFIERS.add(new SpiderPoisonAttack());
        GAME_MODIFIERS.add(new ThrowableWeaponsBleeding());
        GAME_MODIFIERS.add(new TreasureBagManager());
        GAME_MODIFIERS.add(new UndeadArmyEventsHandler());
        GAME_MODIFIERS.add(new WitherSkeletonWithSword());
        GAME_MODIFIERS.add(new WitherSwordItem.Effect());
        GAME_MODIFIERS.add(new ZombiesInGroup());
        new UndeadArmyConfig();
    }

    public static class Modifiers {
        public static final String DEFAULT = Registries.getLocationString("default");
        public static final String UNDEAD_ARMY = Registries.getLocationString("undead_army");
        public static final String GAME_STAGE = Registries.getLocationString("game_stage");
        public static final String TREASURE_BAG = Registries.getLocationString("treasure_bag");
    }
}

