/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects;

import com.majruszsdifficulty.Registries;
import com.mlib.Utility;
import com.mlib.effects.EffectHelper;
import com.mlib.time.TimeHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BleedingEffect
extends MobEffect {
    public BleedingEffect() {
        super(MobEffectCategory.HARMFUL, -2271915);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        net.minecraft.world.effect.MobEffectInstance mobEffectInstance = entity.m_21124_((MobEffect)this);
        if (mobEffectInstance instanceof MobEffectInstance) {
            MobEffectInstance effectInstance = (MobEffectInstance)mobEffectInstance;
            Vec3 motion = entity.m_20184_();
            entity.m_6469_((DamageSource)new EntityBleedingDamageSource(effectInstance.damageSourceEntity), 1.0f);
            entity.m_20256_(motion);
        } else {
            entity.m_6469_(Registries.BLEEDING_SOURCE, 1.0f);
        }
    }

    public void m_19461_(@Nullable Entity source, @Nullable Entity indirectSource, LivingEntity entity, int amplifier, double health) {
    }

    public boolean m_6584_(int duration, int amplifier) {
        int cooldown = Math.max(4, Utility.secondsToTicks((double)4.0) >> amplifier);
        return duration % cooldown == 0;
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    @SubscribeEvent
    public static void onUpdate(LivingEvent.LivingTickEvent event) {
        BleedingEffect bleeding = (BleedingEffect)((Object)Registries.BLEEDING.get());
        LivingEntity entity = event.getEntity();
        if (TimeHelper.hasServerTicksPassed((int)5) && entity.m_21023_((MobEffect)bleeding)) {
            BleedingEffect.spawnParticles(entity, EffectHelper.getEffectAmplifier((LivingEntity)entity, (MobEffect)bleeding) + 3);
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        if (event.getEntity().m_21023_((MobEffect)Registries.BLEEDING.get())) {
            BleedingEffect.spawnParticles(event.getEntity(), 100);
        }
    }

    public static boolean isBleedingSource(DamageSource damageSource) {
        return damageSource.f_19326_.equals(Registries.BLEEDING_SOURCE.f_19326_);
    }

    private static void spawnParticles(LivingEntity entity, int amountOfParticles) {
        Level level = entity.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)((SimpleParticleType)Registries.BLOOD.get()), entity.m_20185_(), entity.m_20227_(0.5), entity.m_20189_(), amountOfParticles, 0.125, 0.5, 0.125, 0.05);
        }
    }

    public static class MobEffectInstance
    extends net.minecraft.world.effect.MobEffectInstance {
        @Nullable
        protected final Entity damageSourceEntity;

        public MobEffectInstance(int duration, int amplifier, boolean ambient, @Nullable LivingEntity attacker) {
            super((MobEffect)Registries.BLEEDING.get(), duration, amplifier, ambient, false, true);
            this.damageSourceEntity = attacker;
        }
    }

    public static class EntityBleedingDamageSource
    extends DamageSource {
        @Nullable
        protected final Entity damageSourceEntity;

        public EntityBleedingDamageSource(@Nullable Entity damageSourceEntity) {
            super(Registries.BLEEDING_SOURCE.f_19326_);
            this.m_19380_();
            this.damageSourceEntity = damageSourceEntity;
        }

        @Nullable
        public Entity m_7640_() {
            return null;
        }

        @Nullable
        public Entity m_7639_() {
            return this.damageSourceEntity;
        }
    }
}

