/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.configs;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.goals.FollowGroupLeaderGoal;
import com.majruszsdifficulty.goals.TargetAsLeaderGoal;
import com.mlib.Random;
import com.mlib.config.ConfigGroup;
import com.mlib.config.IConfigurable;
import com.mlib.config.IntegerConfig;
import com.mlib.gamemodifiers.configs.ItemStackConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class MobGroupConfig
extends ConfigGroup {
    public static final String SIDEKICK_TAG = "MajruszsDifficultySidekick";
    static final int MIN_COUNT = 1;
    static final int MAX_COUNT = 9;
    final List<ItemStackConfig> leaderConfigs = new ArrayList<ItemStackConfig>();
    final List<ItemStackConfig> sidekickConfigs = new ArrayList<ItemStackConfig>();
    final Supplier<EntityType<? extends PathfinderMob>> mob;
    final IntegerConfig min;
    final IntegerConfig max;

    public MobGroupConfig(String groupName, Supplier<EntityType<? extends PathfinderMob>> mob, int min, int max) {
        super(groupName, "", new IConfigurable[0]);
        this.mob = mob;
        this.min = new IntegerConfig("min_count", "Minimum amount of mobs to spawn (leader is not considered).", false, min, 1, 9);
        this.max = new IntegerConfig("max_count", "Maximum amount of mobs to spawn (leader is not considered).", false, max, 1, 9);
        this.addConfigs(new IConfigurable[]{this.min, this.max});
    }

    public void addLeaderConfigs(ItemStackConfig ... configs) {
        this.leaderConfigs.addAll(List.of(configs));
    }

    public void addSidekickConfigs(ItemStackConfig ... configs) {
        this.sidekickConfigs.addAll(List.of(configs));
    }

    public List<PathfinderMob> spawn(PathfinderMob leader) {
        int sidekickAmount = Random.nextInt((int)this.getMinCount(), (int)(this.getMaxCount() + 1));
        Vec3 spawnPosition = leader.m_20182_();
        ArrayList<PathfinderMob> sidekicks = new ArrayList<PathfinderMob>();
        for (int sidekickIdx = 0; sidekickIdx < sidekickAmount; ++sidekickIdx) {
            PathfinderMob sidekick = (PathfinderMob)this.getMob().m_20615_(leader.f_19853_);
            if (sidekick == null) continue;
            sidekick.m_6034_(spawnPosition.f_82479_ + (double)Random.nextInt((int)-3, (int)4), spawnPosition.f_82480_ + 0.5, spawnPosition.f_82481_ + (double)Random.nextInt((int)-3, (int)4));
            sidekick.f_21345_.m_25352_(9, (Goal)new FollowGroupLeaderGoal((Mob)sidekick, (Mob)leader, 1.0, 6.0f, 5.0f));
            sidekick.f_21346_.m_25352_(9, (Goal)new TargetAsLeaderGoal(sidekick, leader));
            sidekick.getPersistentData().m_128379_(SIDEKICK_TAG, true);
            leader.f_19853_.m_7967_((Entity)sidekick);
            sidekicks.add(sidekick);
        }
        this.applyConfigs(leader, sidekicks);
        return sidekicks;
    }

    public EntityType<? extends PathfinderMob> getMob() {
        return this.mob.get();
    }

    public int getMinCount() {
        return Math.min((Integer)this.min.get(), (Integer)this.max.get());
    }

    public int getMaxCount() {
        return Math.max((Integer)this.min.get(), (Integer)this.max.get());
    }

    private void applyConfigs(PathfinderMob leader, List<PathfinderMob> sidekicks) {
        double clampedRegionalDifficulty = GameStage.getRegionalDifficulty((LivingEntity)leader);
        for (ItemStackConfig config : this.leaderConfigs) {
            config.tryToEquip(leader, clampedRegionalDifficulty);
        }
        for (ItemStackConfig config : this.sidekickConfigs) {
            for (PathfinderMob sidekick : sidekicks) {
                config.tryToEquip(sidekick, clampedRegionalDifficulty);
            }
        }
    }
}

