/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.configs;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.config.GameStageDoubleConfig;
import com.majruszsdifficulty.config.GameStageIntegerConfig;
import com.mlib.Utility;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.effects.EffectHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;

public class ProgressiveEffectConfig
extends ConfigGroup {
    static final int MIN_AMPLIFIER = 1;
    static final int MAX_AMPLIFIER = 10;
    static final double MIN_DURATION = 1.0;
    static final double MAX_DURATION = 999.0;
    static final double MIN_LIMIT = 5.0;
    static final double MAX_LIMIT = 999.0;
    final Supplier<MobEffect> effect;
    final GameStageIntegerConfig amplifier;
    final GameStageDoubleConfig duration;
    final Optional<DoubleConfig> maxDuration;

    public ProgressiveEffectConfig(String groupName, Supplier<MobEffect> effect, GameStage.Integer amplifier, GameStage.Double duration, Optional<Double> maxDuration) {
        super(groupName, "", new IConfigurable[0]);
        this.effect = effect;
        this.amplifier = new GameStageIntegerConfig("Amplifier", "Level of the effect to apply.", amplifier.normal() + 1, amplifier.expert() + 1, amplifier.master() + 1, 1, 10);
        this.duration = new GameStageDoubleConfig("Duration", "Duration in seconds.", duration.normal(), duration.expert(), duration.master(), 1.0, 999.0);
        this.maxDuration = maxDuration.map(value -> new DoubleConfig("maximum_duration", "Maximum duration in seconds it can reach.", false, value.doubleValue(), 5.0, 999.0));
        this.addConfigs(new IConfigurable[]{this.amplifier, this.duration});
        this.maxDuration.ifPresent(arg_0 -> ((ProgressiveEffectConfig)this).addConfig(arg_0));
    }

    public ProgressiveEffectConfig(String groupName, Supplier<MobEffect> effect, GameStage.Integer amplifier, GameStage.Double duration) {
        this(groupName, effect, amplifier, duration, Optional.empty());
    }

    public ProgressiveEffectConfig(String groupName, Supplier<MobEffect> effect, GameStage.Integer amplifier, GameStage.Double duration, double maxDuration) {
        this(groupName, effect, amplifier, duration, Optional.of(maxDuration));
    }

    public ProgressiveEffectConfig(String groupName, Supplier<MobEffect> effect, int amplifier, GameStage.Double duration, double maxDuration) {
        this(groupName, effect, new GameStage.Integer(amplifier, amplifier, amplifier), duration, maxDuration);
    }

    public ProgressiveEffectConfig(String groupName, Supplier<MobEffect> effect, int amplifier, GameStage.Double duration) {
        this(groupName, effect, new GameStage.Integer(amplifier, amplifier, amplifier), duration);
    }

    public ProgressiveEffectConfig(String groupName, Supplier<MobEffect> effect, GameStage.Integer amplifier, double duration, double maxDuration) {
        this(groupName, effect, amplifier, new GameStage.Double(duration, duration, duration), maxDuration);
    }

    public ProgressiveEffectConfig(String groupName, Supplier<MobEffect> effect, GameStage.Integer amplifier, double duration) {
        this(groupName, effect, amplifier, new GameStage.Double(duration, duration, duration));
    }

    public ProgressiveEffectConfig(String groupName, Supplier<MobEffect> effect, int amplifier, double duration, double maxDuration) {
        this(groupName, effect, new GameStage.Integer(amplifier, amplifier, amplifier), new GameStage.Double(duration, duration, duration), maxDuration);
    }

    public ProgressiveEffectConfig(String groupName, Supplier<MobEffect> effect, int amplifier, double duration) {
        this(groupName, effect, new GameStage.Integer(amplifier, amplifier, amplifier), new GameStage.Double(duration, duration, duration));
    }

    public void apply(LivingEntity entity) {
        if (this.maxDuration.isPresent()) {
            EffectHelper.stackEffectIfPossible((LivingEntity)entity, (MobEffect)this.getEffect(), (int)this.getDuration(), (int)this.getAmplifier(), (int)this.getMaxDuration());
        } else {
            EffectHelper.applyEffectIfPossible((LivingEntity)entity, (MobEffect)this.getEffect(), (int)this.getDuration(), (int)this.getAmplifier());
        }
    }

    public MobEffect getEffect() {
        return this.effect.get();
    }

    public int getAmplifier() {
        return (Integer)this.amplifier.getCurrentGameStageValue() - 1;
    }

    public int getDuration() {
        return Utility.secondsToTicks((double)((Double)this.duration.getCurrentGameStageValue()));
    }

    public int getMaxDuration() {
        assert (this.maxDuration.isPresent());
        return this.maxDuration.get().asTicks();
    }
}

