/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.Registries;
import com.majruszsdifficulty.config.GameStageIntegerConfig;
import com.majruszsdifficulty.entities.CreeperlingEntity;
import com.majruszsdifficulty.gamemodifiers.CustomConditions;
import com.mlib.Random;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ContextBase;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnDeathContext;
import com.mlib.gamemodifiers.contexts.OnExplosionContext;
import com.mlib.gamemodifiers.data.OnDeathData;
import com.mlib.gamemodifiers.data.OnExplosionData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.ExplosionEvent;

public class CreeperSplitIntoCreeperlings
extends GameModifier {
    final GameStageIntegerConfig creeperlingsAmount = new GameStageIntegerConfig("MaxCreeperlings", "Maximum amount of Creeperlings to spawn.", 2, 4, 6, 1, 10);

    public CreeperSplitIntoCreeperlings() {
        super(Registries.Modifiers.DEFAULT, "CreeperSplitIntoCreeperlings", "When the Creeper explode it may spawn a few Creeperlings.");
        OnExplosionContext onExplosion = new OnExplosionContext(this::spawnCreeperlings);
        onExplosion.addCondition((Condition)new CustomConditions.GameStage(GameStage.Stage.NORMAL)).addCondition((Condition)new CustomConditions.CRDChance(0.666, false)).addCondition((Condition)new Condition.Excludable()).addCondition(data -> data.explosion.getExploder() instanceof Creeper && !(data.explosion.getExploder() instanceof CreeperlingEntity)).addCondition(data -> data.event instanceof ExplosionEvent.Detonate).addConfig((IConfigurable)this.creeperlingsAmount);
        OnExplosionContext onExplosion2 = new OnExplosionContext(this::giveAdvancement);
        onExplosion2.addCondition(data -> data.explosion.getExploder() instanceof CreeperlingEntity && data.level != null);
        OnDeathContext onDeath = new OnDeathContext(this::giveAdvancement);
        onDeath.addCondition(data -> data.attacker instanceof ServerPlayer).addCondition(data -> data.target instanceof CreeperlingEntity);
        this.addContexts(new ContextBase[]{onExplosion, onExplosion2, onDeath});
    }

    private void spawnCreeperlings(OnExplosionData data) {
        Creeper creeper = (Creeper)data.explosion.getExploder();
        ServerLevel level = data.level;
        int creeperlingsAmount = Random.nextInt((int)1, (int)((Integer)this.creeperlingsAmount.getCurrentGameStageValue() + 1));
        assert (creeper != null && level != null);
        for (int i = 0; i < creeperlingsAmount; ++i) {
            BlockPos position = creeper.m_20183_().m_121955_(Random.getRandomVector3i((int)-2, (int)2, (int)-1, (int)1, (int)-2, (int)2));
            CreeperlingEntity creeperling = (CreeperlingEntity)((EntityType)Registries.CREEPERLING.get()).m_20600_(level, null, null, null, position, MobSpawnType.SPAWNER, true, true);
            if (creeperling == null) continue;
            creeperling.m_6710_(creeper.m_5448_());
        }
    }

    private void giveAdvancement(OnExplosionData data) {
        assert (data.level != null);
        Vec3 position = ((ExplosionEvent)data.event).getExplosion().getPosition();
        Vec3 offset = new Vec3(10.0, 6.0, 10.0);
        List nearbyPlayers = data.level.m_45976_(ServerPlayer.class, new AABB(position.m_82546_(offset), position.m_82549_(offset)));
        nearbyPlayers.forEach(this::giveAdvancement);
    }

    private void giveAdvancement(OnDeathData data) {
        this.giveAdvancement((ServerPlayer)data.attacker);
    }

    private void giveAdvancement(ServerPlayer player) {
        Registries.BASIC_TRIGGER.trigger(player, "encountered_creeperling");
    }
}

