/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamemodifiers.list;

import com.majruszsdifficulty.GameStage;
import com.majruszsdifficulty.Registries;
import com.mlib.Random;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfigurable;
import com.mlib.gamemodifiers.Condition;
import com.mlib.gamemodifiers.ContextBase;
import com.mlib.gamemodifiers.GameModifier;
import com.mlib.gamemodifiers.contexts.OnExplosionContext;
import com.mlib.gamemodifiers.data.OnExplosionData;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.level.ExplosionEvent;

public class PowerfulExplosions
extends GameModifier {
    final DoubleConfig radiusMultiplier = new DoubleConfig("radius_multiplier", "Multiplies explosion radius by the given value (this value is scaled by Clamped Regional Difficulty).", false, 1.2599, 1.0, 10.0);
    final DoubleConfig fireChance = new DoubleConfig("fire_chance", "Gives all explosions a chance to cause fire (this value is scaled by Clamped Regional Difficulty).", false, 0.75, 0.0, 1.0);

    public PowerfulExplosions() {
        super(Registries.Modifiers.DEFAULT, "PowerfulExplosions", "Makes all explosions (creepers, ghast ball etc.) much more deadly.");
        OnExplosionContext onExplosion = new OnExplosionContext(this::modifyExplosion);
        onExplosion.addCondition((Condition)new Condition.Excludable()).addCondition(data -> data.level != null).addCondition(data -> data.event instanceof ExplosionEvent.Start).addConfigs(new IConfigurable[]{this.radiusMultiplier, this.fireChance});
        this.addContext((ContextBase)onExplosion);
    }

    private void modifyExplosion(OnExplosionData data) {
        double clampedRegionalDifficulty = GameStage.getRegionalDifficulty((Level)data.level, data.explosion.getPosition());
        double radiusMultiplier = clampedRegionalDifficulty * ((Double)this.radiusMultiplier.get() - 1.0) + 1.0;
        data.radius.setValue((Number)(radiusMultiplier * (double)data.radius.getValue().floatValue()));
        if (Random.tryChance((double)(clampedRegionalDifficulty * (Double)this.fireChance.get()))) {
            data.causesFire.setValue(true);
        }
    }
}

